/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.test.diagram.common.ju.context.CDBDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.tools.RenameTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ToolHelper;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class ConstraintRename
extends XABDiagramsProject {
    public static String RENAME_CONSTRAINT_TOOL = "Constraint Content";
    public static String NEW_NAME = "New Constraint";

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnCDB(session, context);
        this.testOnXAB(session, context, "6ffa67ff-1bf1-4ccf-99aa-89623c99a253");
        this.testOnXAB(session, context, "2937d0b4-1d8b-4199-99e0-72605bfd87ca");
        this.testOnXAB(session, context, "b4fd3a2f-a53d-4da7-bec4-8fd7169d2caa");
        this.testOnXAB(session, context, "8dae69b8-87f7-45c0-9f95-f72009aa4c1c");
        this.testOnXAB(session, context, "6117356a-8b31-480f-a1ed-07e8da164fbd");
    }

    private void testOnCDB(Session session, SessionContext context) {
        CDBDiagram cdbDiagram = CDBDiagram.createDiagram((SessionContext)context, (String)"cb34448a-cdbf-46af-b02d-56303ca5e0ce");
        ToolHelper toolhelper = new ToolHelper(session, cdbDiagram.getDiagram());
        AbstractToolDescription tool = toolhelper.getTool(RENAME_CONSTRAINT_TOOL);
        ConstraintRename.assertTrue((String)"Rename tool has not been found", (tool != null && tool instanceof DirectEditLabel ? 1 : 0) != 0);
        DirectEditLabel renameTool = (DirectEditLabel)tool;
        ConstraintRename.assertTrue((String)"Constraint's name should be displayed when rename tool is applied", (renameTool.getInputLabelExpression() != null && renameTool.getInputLabelExpression().equals("feature:name") ? 1 : 0) != 0);
    }

    public void testOnXAB(Session session, SessionContext context, String element) {
        XABDiagram xabDiagram = XABDiagram.createDiagram((SessionContext)context, (String)element);
        xabDiagram.createConstraint(GenericModel.CONSTRAINT_1);
        Constraint constraint = (Constraint)xabDiagram.getSessionContext().getSemanticElement(GenericModel.CONSTRAINT_1);
        new RenameTool((DiagramContext)xabDiagram, RENAME_CONSTRAINT_TOOL, (EObject)constraint, NEW_NAME).run();
        ConstraintRename.assertTrue((String)"The constraint has not been renamed", (boolean)constraint.getName().equals(NEW_NAME));
    }
}

