/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreatePhysicalLink
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, this.getValidLinks(BlockArchitectureExt.Type.SA), this.getInvalidLinks(BlockArchitectureExt.Type.SA));
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, this.getValidLinks(BlockArchitectureExt.Type.LA), this.getInvalidLinks(BlockArchitectureExt.Type.LA));
        this.testOnXAB(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, this.getValidLinks(BlockArchitectureExt.Type.PA), this.getInvalidLinks(BlockArchitectureExt.Type.PA));
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, List<LinkInfo> validLinks, List<LinkInfo> invalidLinks) {
        String linkId;
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        for (LinkInfo linkInfo : validLinks) {
            linkId = String.valueOf(GenericModel.PHYSICAL_LINK_1) + linkInfo.source;
            diagram.createPhysicalLink(linkInfo.source, linkInfo.target, linkId);
            DSemanticDecorator link = diagram.getView(linkId);
            EObject expected = diagram.getSessionContext().getSemanticElement(linkInfo.expectedContainer);
            EObject actual = link.getTarget().eContainer();
            CreatePhysicalLink.assertEquals((Object)expected, (Object)actual);
        }
        for (LinkInfo linkInfo : invalidLinks) {
            linkId = String.valueOf(GenericModel.PHYSICAL_LINK_1) + linkInfo.source;
            diagram.cannotCreatePhysicalLink(linkInfo.source, linkInfo.target, linkId);
        }
    }

    protected List<LinkInfo> getValidLinks(BlockArchitectureExt.Type type) {
        ArrayList<LinkInfo> validLinks = new ArrayList<LinkInfo>();
        switch (type) {
            case SA: {
                validLinks.add(new LinkInfo("ff952c1b-4605-414e-892b-7fc1e0886826", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2", "09d06243-63db-4202-b519-9faf7c82322a"));
                validLinks.add(new LinkInfo("ff952c1b-4605-414e-892b-7fc1e0886826", "f280765d-965a-42bd-b886-616dc643361f", "09d06243-63db-4202-b519-9faf7c82322a"));
                break;
            }
            case LA: {
                validLinks.add(new LinkInfo("e7884bff-642d-44ac-bce6-c3cd20aa03b1", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("6b64bc6d-7666-4202-8727-bb039a76d172", "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "6b64bc6d-7666-4202-8727-bb039a76d172", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "6b64bc6d-7666-4202-8727-bb039a76d172", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("6b64bc6d-7666-4202-8727-bb039a76d172", "f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("0ad59536-7a71-4698-acc6-527aeaccf49b", "e7884bff-642d-44ac-bce6-c3cd20aa03b1", "f98a5409-24f8-4207-bb68-38b721762d2f"));
                validLinks.add(new LinkInfo("0ad59536-7a71-4698-acc6-527aeaccf49b", "f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "09441ac0-4fa8-42c6-8c73-a27d6602b8ed"));
                validLinks.add(new LinkInfo("0ad59536-7a71-4698-acc6-527aeaccf49b", "16a1fba7-3672-4f4c-85f2-29b870344e2c", "a2673077-7c94-4e97-8261-a9c676aa4b79"));
                break;
            }
            case PA: {
                validLinks.add(new LinkInfo("f2cb610a-e6a1-4001-9d3e-d9108d6d7091", "6f03c5ec-9bc4-4ba9-b162-e2b37e757d94", "6117356a-8b31-480f-a1ed-07e8da164fbd"));
                break;
            }
        }
        return validLinks;
    }

    protected List<LinkInfo> getInvalidLinks(BlockArchitectureExt.Type type) {
        ArrayList<LinkInfo> invalidLinks = new ArrayList<LinkInfo>();
        switch (type) {
            case LA: {
                invalidLinks.add(new LinkInfo("6b64bc6d-7666-4202-8727-bb039a76d172", "c30f774e-9dd2-406e-a611-14f59ebcb96c", null));
                invalidLinks.add(new LinkInfo("c30f774e-9dd2-406e-a611-14f59ebcb96c", "6b64bc6d-7666-4202-8727-bb039a76d172", null));
                invalidLinks.add(new LinkInfo("c30f774e-9dd2-406e-a611-14f59ebcb96c", "e7884bff-642d-44ac-bce6-c3cd20aa03b1", null));
                invalidLinks.add(new LinkInfo("e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", "c30f774e-9dd2-406e-a611-14f59ebcb96c", null));
                invalidLinks.add(new LinkInfo("f4e0c504-fc0c-4d0d-b10e-5227cfa0d28f", "c30f774e-9dd2-406e-a611-14f59ebcb96c", null));
                invalidLinks.add(new LinkInfo("1f6b0cc6-e789-4df0-836d-3130bd55e8c4", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", null));
                invalidLinks.add(new LinkInfo("1f6b0cc6-e789-4df0-836d-3130bd55e8c4", "c30f774e-9dd2-406e-a611-14f59ebcb96c", null));
                invalidLinks.add(new LinkInfo("6b64bc6d-7666-4202-8727-bb039a76d172", "1f6b0cc6-e789-4df0-836d-3130bd55e8c4", null));
                break;
            }
        }
        return invalidLinks;
    }

    private class LinkInfo {
        String source;
        String target;
        String expectedContainer;

        public LinkInfo(String source, String target, String expectedContainer) {
            this.source = source;
            this.target = target;
            this.expectedContainer = expectedContainer;
        }
    }
}

