/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles.StyleConfigurationRegistry;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DiagramPartIcon
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        Part system = (Part)((Component)context.getSemanticElement("b4fd3a2f-a53d-4da7-bec4-8fd7169d2caa")).getAbstractTypedElements().get(0);
        XABDiagram sab = XABDiagram.openDiagram((SessionContext)context, (String)"[SAB] System", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.SA);
        this.checkIcons(sab, sab.getView((EObject)system));
        Part lsystem = (Part)context.getSemanticElement("6b64bc6d-7666-4202-8727-bb039a76d172");
        XABDiagram lab = XABDiagram.openDiagram((SessionContext)context, (String)"[LAB] Logical System", (BlockArchitectureExt.Type)BlockArchitectureExt.Type.LA);
        this.checkIcons(lab, lab.getView((EObject)lsystem));
        PABDiagram pab = PABDiagram.openDiagram((SessionContext)context, (String)"[PAB] Physical System");
        pab.clearDiagram();
        pab.createNodeComponent("n", pab.getDiagramId());
        pab.createDeployedBehaviorComponent("b", "n");
        this.checkIcons((XABDiagram)pab, (DDiagramElement)pab.getView("n"));
        this.checkIcons((XABDiagram)pab, (DDiagramElement)pab.getView("b"));
    }

    private void checkIcons(XABDiagram diagram, DDiagramElement view) {
        StyleConfiguration c = StyleConfigurationRegistry.getInstance().getStyleConfiguration(view.getDiagramElementMapping(), view.getStyle());
        this.updateApproach(CapellaProjectHelper.ProjectApproach.SingletonComponents, diagram.getDiagramDescriptor().getTarget());
        Image imageCpt = c.getLabelIcon(view, null);
        Image imageCpt2 = c.getLabelIcon(view, null);
        DiagramPartIcon.assertTrue((String)"Icon shall be equal between two calls", (imageCpt == imageCpt2 ? 1 : 0) != 0);
        this.updateApproach(CapellaProjectHelper.ProjectApproach.ReusableComponents, diagram.getDiagramDescriptor().getTarget());
        Image imagePart = c.getLabelIcon(view, null);
        Image imagePart2 = c.getLabelIcon(view, null);
        DiagramPartIcon.assertTrue((String)"Icon shall be equal between two calls", (imagePart == imagePart2 ? 1 : 0) != 0);
        DiagramPartIcon.assertTrue((String)"Icon on multipart shall be different than standard mode", (imageCpt != imagePart ? 1 : 0) != 0);
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                DiagramPartIcon.assertTrue((String)"Icon on part without type shall not raise an error message", (boolean)false);
            }
        };
        DiagramPlugin.getDefault().getLog().addLogListener(listener);
        try {
            try {
                this.updateApproach(CapellaProjectHelper.ProjectApproach.SingletonComponents, diagram.getDiagramDescriptor().getTarget());
                Image imagePart3 = c.getLabelIcon(view, null);
                this.removePartType((Part)view.getTarget());
                Image imagePart4 = c.getLabelIcon(view, null);
                Image imagePart5 = c.getLabelIcon(view, null);
                DiagramPartIcon.assertTrue((String)"Icon shall be equal different than with a type", (imagePart3 != imagePart4 ? 1 : 0) != 0);
                DiagramPartIcon.assertTrue((String)"Icon shall be equal between two calls", (imagePart4 == imagePart5 ? 1 : 0) != 0);
            }
            catch (Exception e) {
                DiagramPartIcon.assertTrue((String)"Icon on part without type shall not raise an Exception", (boolean)false);
                DiagramPlugin.getDefault().getLog().removeLogListener(listener);
            }
        }
        finally {
            DiagramPlugin.getDefault().getLog().removeLogListener(listener);
        }
    }

    private void removePartType(final Part source) {
        TransactionHelper.getExecutionManager((EObject)source).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                source.setAbstractType(null);
            }
        });
    }

    private void updateApproach(final CapellaProjectHelper.ProjectApproach approach, final EObject source) {
        TransactionHelper.getExecutionManager((EObject)source).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                CapellaProjectHelper.setProjectWithApproach((Project)ProjectExt.getProject((EObject)source), (CapellaProjectHelper.ProjectApproach)approach);
            }
        });
    }
}

