/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DragAndDropFunction
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        String[] oaIds = new String[]{"d7d31666-d9d5-4caa-bf77-cb348efcc248", "843281f3-00bc-4c34-b1e9-79f9065049a0"};
        String[] saIds = new String[]{"5eef3339-1e33-4cc4-9968-58b7b128f28a"};
        String[] laIds = new String[]{"02f0848d-2783-4079-b392-96b837442a54", "a11c69aa-21bd-449c-9f43-ae138ec00974"};
        String[] paIds = new String[]{"7f785891-6327-4536-a532-581c0c46980c", "1a21afe9-0f85-48ff-9ee2-d2e0c070702d"};
        this.testOnXAB(context, "[OAB] Operational Context", "2937d0b4-1d8b-4199-99e0-72605bfd87ca", oaIds);
        this.testOnXAB(context, "[SAB] System", "325e94ec-99cd-47ef-b1f0-8fa15fb50ca2", saIds);
        this.testOnXAB(context, "[LAB] Logical System", "e671feb7-b6b3-40c0-8f2c-ff2b5ef349f0", laIds);
        this.testOnXAB(context, "[PAB] Physical System", "053143f1-d4fe-4f85-8f21-58720afa63db", paIds);
    }

    public void testOnXAB(SessionContext context, String diagramName, String containerId, String ... ids) {
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, diagramName).run();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            DNode beforeDnDLFNode = (DNode)diagramContext.getView(context.getSemanticElement(id));
            RGBValues beforeDnDRgb = beforeDnDLFNode.getOwnedStyle().getBorderColor();
            int beforeDnDRed = beforeDnDRgb.getRed();
            int beforeDnDGreen = beforeDnDRgb.getGreen();
            int beforeDnDBlue = beforeDnDRgb.getBlue();
            int beforeDnDHeight = beforeDnDLFNode.getHeight();
            int beforeDnDWidth = beforeDnDLFNode.getWidth();
            new DragAndDropTool(diagramContext, "DnD AB AbstractFunction Allocation", id, containerId).run();
            DNode afterDnDLFNode = (DNode)diagramContext.getView(context.getSemanticElement(id));
            RGBValues afterDnDRgb = afterDnDLFNode.getOwnedStyle().getBorderColor();
            int afterDnDRed = afterDnDRgb.getRed();
            int afterDnDGreen = afterDnDRgb.getGreen();
            int afterDnDBlue = afterDnDRgb.getBlue();
            int afterDnDHeight = afterDnDLFNode.getHeight();
            int afterDnDWidth = afterDnDLFNode.getWidth();
            DragAndDropFunction.assertTrue((String)"LF must have the same size after the DnD from Logical System to LA", (beforeDnDHeight == afterDnDHeight && beforeDnDWidth == afterDnDWidth ? 1 : 0) != 0);
            DragAndDropFunction.assertTrue((String)"LF must have the same color after the DnD from Logical System to LA", (beforeDnDRed == afterDnDRed && beforeDnDGreen == afterDnDGreen && beforeDnDBlue == afterDnDBlue ? 1 : 0) != 0);
            ++n2;
        }
    }

    @Override
    protected String getRequiredTestModel() {
        return "XABDiagrams";
    }
}

