/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.framework.context.SessionContext;

public class PhysicalPathDisplay
extends AbstractDiagramTestCase {
    protected Session session;
    protected SessionContext context;
    public static final String PA__PAB_DIAGRAM = "[PAB] Physical System";
    public static final String PHYSICAL_SYSTEM = "b501d39f-3d93-4b07-9c6e-12e4c9c425c4";
    public static final String PA__PAB_NOODLE_BAG_DIAGRAM = "[PAB] Noodle Bag";
    public static final String NOODLE_BAG_PHYSICAL_PATH = "9851607d-ac87-4c9c-8a0c-b20f5b34dac2";

    protected void initTest() {
        this.session = this.getSession(this.getRequiredTestModel());
        this.context = new SessionContext(this.session);
    }

    public void test() throws Exception {
        this.initTest();
        this.testCompositePhysicalPaths();
        this.testNoodleBagPhysicalPath();
    }

    protected void testCompositePhysicalPaths() {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)this.context, (String)PA__PAB_DIAGRAM, (BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA);
        PhysicalComponent physicalSystem = (PhysicalComponent)this.context.getSemanticElement(PHYSICAL_SYSTEM);
        for (PhysicalPath path : physicalSystem.getOwnedPhysicalPath()) {
            if (!path.getName().startsWith("Compound")) continue;
            diagram.insertPhysicalPath(new String[]{path.getId()});
            diagram.refreshDiagram();
            Optional<Involvement> plInvOpt = path.getInvolvedInvolvements().stream().filter(i -> i.getInvolved() instanceof PhysicalLink).findFirst();
            PhysicalPathDisplay.assertTrue((boolean)plInvOpt.isPresent());
            PhysicalLink pl = (PhysicalLink)plInvOpt.get().getInvolved();
            DDiagramContents ctx = new DDiagramContents(diagram.getDiagram());
            DiagramElementMapping physicalLinkEdgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingABPhysicalLink((DDiagram)ctx.getDDiagram()));
            DiagramElementMapping internalPhysicalLinkEdgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingPhysicalPathInternLink((DDiagram)ctx.getDDiagram()));
            DiagramElementMapping pathMapping = ctx.getMapping(MappingConstantsHelper.getMappingPhysicalPath((DDiagram)ctx.getDDiagram()));
            Collection plEdges = DiagramServices.getDiagramServices().getDiagramElements(diagram.getDiagram(), physicalLinkEdgeMapping, (EObject)pl);
            Collection internalPLEdges = DiagramServices.getDiagramServices().getDiagramElements(diagram.getDiagram(), internalPhysicalLinkEdgeMapping, (EObject)path);
            DNode pathView = (DNode)DiagramServices.getDiagramServices().getDiagramElement(diagram.getDiagram(), pathMapping, (EObject)path);
            for (DDiagramElement plEdge : plEdges) {
                PhysicalPathDisplay.assertTrue((boolean)(plEdge instanceof DEdge));
                PhysicalPathDisplay.assertTrue((String)("The Physical Link " + pl.getName() + " is not colored when the Physical Path " + path.getName() + " is displayed."), (boolean)((DEdge)plEdge).getOwnedStyle().getStrokeColor().equals((Object)((Square)pathView.getOwnedStyle()).getColor()));
            }
            PhysicalPathDisplay.assertTrue((String)("There should be 2 interal links for " + path.getName() + "."), (internalPLEdges.stream().filter(e -> e.getTarget().equals(path)).count() == 2L ? 1 : 0) != 0);
            diagram.removePhysicalPath(new String[]{path.getId()});
            diagram.refreshDiagram();
        }
    }

    protected void testNoodleBagPhysicalPath() {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)this.context, (String)PA__PAB_NOODLE_BAG_DIAGRAM, (BlockArchitectureExt.Type)BlockArchitectureExt.Type.PA);
        PhysicalPath physicalPath = (PhysicalPath)this.context.getSemanticElement(NOODLE_BAG_PHYSICAL_PATH);
        diagram.insertPhysicalPath(new String[]{physicalPath.getId()});
        diagram.refreshDiagram();
        DDiagramContents ctx = new DDiagramContents(diagram.getDiagram());
        DiagramElementMapping internalPhysicalLinkEdgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingPhysicalPathInternLink((DDiagram)ctx.getDDiagram()));
        Collection internalPLEdges = DiagramServices.getDiagramServices().getDiagramElements(diagram.getDiagram(), internalPhysicalLinkEdgeMapping, (EObject)physicalPath);
        PhysicalPathDisplay.assertTrue((String)("There should be 6 interal links for " + physicalPath.getName() + "."), (internalPLEdges.stream().filter(e -> e.getTarget().equals(physicalPath)).count() == 6L ? 1 : 0) != 0);
    }

    public String getRequiredTestModel() {
        return PhysicalPathDisplay.class.getSimpleName();
    }
}

