/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.text.MessageFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.HelperMessages;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class ShowHideComponentExchanges
extends EmptyProject {
    protected void createLink(XABDiagram xab, String idSource, String idTarget, String id) {
        xab.createComponentExchange(idSource, idTarget, id);
    }

    protected void insertLink(XABDiagram xab, String id, String containerId) {
        xab.insertComponentExchange(id, containerId);
    }

    protected void removeLink(XABDiagram xab, String id, String containerId) {
        xab.removeComponentExchange(id, containerId);
    }

    public void createSubComponent(PABDiagram xab, String id, String containerId) {
        xab.createBehaviorComponent(id, containerId);
    }

    public void createDeployedSubComponent(PABDiagram xab, String id, String containerId) {
        xab.createDeployedBehaviorComponent(id, containerId);
    }

    public void removeSubComponent(PABDiagram xab, String id, String containerId) {
        xab.removeBehaviorComponent(id, containerId);
    }

    public void removeDeployedSubComponent(PABDiagram xab, String id, String containerId) {
        xab.removeDeployedBehaviorComponent(id, containerId);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnDeployedPhysicalComponents(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnUnDeployedPhysicalComponents(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnPhysicalComponents(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnActors(context, "b121dd59-9d3f-4c21-94ae-87e957aaa2a9");
        this.testOnActors(context, "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnActors(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnLogicalComponents(context, "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testCE(context);
    }

    protected void testCE(SessionContext context) {
        this.testCEOnDeployedPhysicalComponents(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
    }

    private void testOnXAB(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters((XABDiagram)xab);
        this.createSubComponent(xab, GenericModel.LC_1, xab.getDiagramId());
        this.createSubComponent(xab, GenericModel.LC_2, GenericModel.LC_1);
        this.createSubComponent(xab, GenericModel.LC_3, GenericModel.LC_2);
        this.createSubComponent(xab, GenericModel.LC_4, GenericModel.LC_1);
        this.createLink((XABDiagram)xab, GenericModel.LC_2, GenericModel.LC_4, GenericModel.CL_1);
        this.createDelegationLink((XABDiagram)xab, GenericModel.LC_1, GenericModel.LC_2, GenericModel.CL_2);
        this.createDelegationLink((XABDiagram)xab, GenericModel.LC_2, GenericModel.LC_3, GenericModel.CL_3);
        this.removeSubComponent(xab, GenericModel.LC_1, xab.getDiagramId());
        xab.refreshDiagram();
        xab.hasntView(GenericModel.LC_1);
        xab.hasntView(GenericModel.LC_2);
        xab.hasntView(GenericModel.LC_3);
        xab.hasntView(GenericModel.LC_4);
        xab.setContextualElements(new String[]{GenericModel.LC_2});
        xab.refreshDiagram();
        xab.hasView(GenericModel.LC_2);
        xab.hasView(GenericModel.LC_4);
        xab.hasntView(GenericModel.LC_1);
        xab.hasntView(GenericModel.LC_3);
    }

    protected void createDelegationLink(XABDiagram xab, String idSource, String idTarget, String id) {
        xab.createComponentExchangeDelegation(idSource, idTarget, id);
    }

    protected void testOnActors(SessionContext context, String idSource) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters(xab);
        if (xab.getDiagramType() == BlockArchitectureExt.Type.LA) {
            xab.insertComponent("ca2e0d95-cba7-4606-8734-00c23f117ce8");
        }
        xab.createActor(GenericModel.LA_1);
        xab.createActor(GenericModel.LA_2);
        this.createLink(xab, GenericModel.LA_1, GenericModel.LA_2, GenericModel.CL_1);
        xab.hasView(GenericModel.LA_1);
        xab.hasView(GenericModel.LA_2);
        xab.removeActor(GenericModel.LA_2);
        this.insertLink(xab, GenericModel.CL_1, GenericModel.LA_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)false);
        this.removeLink(xab, GenericModel.CL_1, GenericModel.LA_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)true);
    }

    protected void testOnLogicalComponents(SessionContext context, String idSource) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters(xab);
        if (xab.getDiagramType() == BlockArchitectureExt.Type.LA) {
            xab.insertComponent("ca2e0d95-cba7-4606-8734-00c23f117ce8");
        }
        xab.createComponent(GenericModel.LC_1, "ca2e0d95-cba7-4606-8734-00c23f117ce8");
        xab.createComponent(GenericModel.LC_2, "ca2e0d95-cba7-4606-8734-00c23f117ce8");
        xab.createComponent(GenericModel.LC_2_1, GenericModel.LC_2);
        this.createLink(xab, GenericModel.LC_1, GenericModel.LC_2_1, GenericModel.CL_1);
        xab.removeComponent(GenericModel.LC_2_1);
        this.insertLink(xab, GenericModel.CL_1, GenericModel.LC_1);
        xab.hasView(GenericModel.LC_2_1);
        xab.mustGraphicalOwnedBy(GenericModel.LC_2_1, GenericModel.LC_2);
        xab.removeComponent(GenericModel.LC_1);
        this.insertLink(xab, GenericModel.CL_1, GenericModel.LC_2_1);
        xab.hasView(GenericModel.LC_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)false);
        this.removeLink(xab, GenericModel.CL_1, GenericModel.LC_2_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)true);
    }

    protected void testOnPhysicalComponents(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters((XABDiagram)xab);
        this.createSubComponent(xab, GenericModel.LC_1, xab.getDiagramId());
        this.createSubComponent(xab, GenericModel.LC_2, xab.getDiagramId());
        this.createSubComponent(xab, GenericModel.LC_2_1, GenericModel.LC_2);
        this.createLink((XABDiagram)xab, GenericModel.LC_1, GenericModel.LC_2_1, GenericModel.CL_1);
        this.removeSubComponent(xab, GenericModel.LC_2_1, GenericModel.LC_2);
        this.insertLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_1);
        xab.hasView(GenericModel.LC_2_1);
        xab.mustGraphicalOwnedBy(GenericModel.LC_2_1, GenericModel.LC_2);
        this.removeSubComponent(xab, GenericModel.LC_1, xab.getDiagramId());
        this.insertLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_2_1);
        xab.hasView(GenericModel.LC_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)false);
        this.removeLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_2_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)true);
    }

    protected void testOnDeployedPhysicalComponents(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters((XABDiagram)xab);
        xab.createNodeComponent(GenericModel.LC_1, xab.getDiagramId());
        this.createDeployedSubComponent(xab, GenericModel.LC_2, GenericModel.LC_1);
        xab.createNodeComponent(GenericModel.LC_3, xab.getDiagramId());
        this.createDeployedSubComponent(xab, GenericModel.LC_4, GenericModel.LC_3);
        this.createLink((XABDiagram)xab, GenericModel.LC_2, GenericModel.LC_4, GenericModel.CL_1);
        xab.removeNodeComponent(GenericModel.LC_3, xab.getDiagramId());
        xab.hasntView(GenericModel.LC_3);
        xab.hasntView(GenericModel.LC_4);
        this.insertLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_2);
        xab.hasView(GenericModel.LC_4, "PAB_PC");
        xab.hasntView(GenericModel.LC_3);
        this.removeSubComponent(xab, GenericModel.LC_4, xab.getDiagramId());
        xab.insertNodeComponent(GenericModel.LC_3, xab.getDiagramId());
        this.assertFilterActive(xab.getDiagram(), this.getFilterName());
        this.insertLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_2);
        xab.hasView(GenericModel.LC_4, "PAB_Deployment");
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)false);
        this.removeLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_2);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)true);
    }

    protected void testCEOnDeployedPhysicalComponents(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters((XABDiagram)xab);
        xab.createNodeComponent(GenericModel.LC_1, xab.getDiagramId());
        this.createDeployedSubComponent(xab, GenericModel.LC_2, GenericModel.LC_1);
        xab.createNodeComponent(GenericModel.LC_3, xab.getDiagramId());
        this.createDeployedSubComponent(xab, GenericModel.LC_4, GenericModel.LC_3);
        xab.createBehaviorComponent(GenericModel.PC_2_1, xab.getDiagramId());
        xab.createDeployedNodeComponent(GenericModel.PC_3_1, GenericModel.LC_1);
        this.createLink((XABDiagram)xab, GenericModel.LC_2, GenericModel.PC_2_1, GenericModel.CL_4);
        xab.removeDeployedBehaviorComponent(GenericModel.LC_2, GenericModel.LC_1);
        xab.hasntView(GenericModel.LC_2);
        this.insertLink((XABDiagram)xab, GenericModel.CL_4, GenericModel.PC_2_1);
        xab.hasView(GenericModel.LC_2, "PAB_Deployment");
        xab.removeDeployedBehaviorComponent(GenericModel.LC_2, GenericModel.LC_1);
        xab.hasntView(GenericModel.LC_2);
        xab.removeDeployedBehaviorComponent(GenericModel.LC_4, GenericModel.LC_3);
        xab.hasntView(GenericModel.LC_4);
        this.insertLink((XABDiagram)xab, GenericModel.CL_4, GenericModel.PC_2_1);
        xab.hasView(GenericModel.LC_2, "PAB_PC");
    }

    protected void testOnUnDeployedPhysicalComponents(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        this.activateComponentExchangeFilters((XABDiagram)xab);
        this.createSubComponent(xab, GenericModel.LC_1, xab.getDiagramId());
        xab.createNodeComponent(GenericModel.LC_2, xab.getDiagramId());
        this.createDeployedSubComponent(xab, GenericModel.LC_3, GenericModel.LC_2);
        this.createLink((XABDiagram)xab, GenericModel.LC_1, GenericModel.LC_3, GenericModel.CL_1);
        this.removeDeployedSubComponent(xab, GenericModel.LC_3, GenericModel.LC_2);
        this.insertLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_1);
        xab.hasView(GenericModel.LC_3, "PAB_PC");
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)false);
        this.removeLink((XABDiagram)xab, GenericModel.CL_1, GenericModel.LC_1);
        DiagramHelper.setSynchronized((DDiagram)xab.getDiagram(), (boolean)true);
    }

    protected void activateFilter(DDiagram diagram, String filterName) {
        FilterDescription filter = DiagramHelper.getFilterForDiagram((DDiagram)diagram, (String)filterName);
        Assert.assertNotNull((String)MessageFormat.format(HelperMessages.filterNotFound, filterName, EObjectExt.getText((EObject)diagram)), (Object)filter);
        DiagramHelper.addFilterInDiagram((DDiagram)diagram, (FilterDescription)filter);
    }

    protected String getFilterName() {
        return "hide.computed.component.exchanges.filter";
    }

    protected void assertFilterActive(DDiagram diagram, String filterName) {
        FilterDescription filter = DiagramHelper.getFilterForDiagram((DDiagram)diagram, (String)filterName);
        Assert.assertNotNull((String)MessageFormat.format(HelperMessages.filterNotFound, filterName, EObjectExt.getText((EObject)diagram)), (Object)filter);
        EList activatedFilters = diagram.getActivatedFilters();
        ShowHideComponentExchanges.assertTrue((boolean)activatedFilters.contains((Object)filter));
    }

    protected void activateComponentExchangeFilters(final XABDiagram xab) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                DAnnotationHelper.deleteAnnotation((String)"https://www.polarsys.org/capella/dannotation/DesactivatedFilters", (DModelElement)xab.getDiagramDescriptor());
            }
        };
        TestHelper.getExecutionManager((EObject)xab.getDiagram()).execute((ICommand)cmd);
        if (xab.getDiagramType() != BlockArchitectureExt.Type.SA) {
            this.activateFilter(xab.getDiagram(), "hide.simplified.group.of.component.exchanges.filter");
            this.activateFilter(xab.getDiagram(), "hide.simplified.oriented.grouped.component.exchanges.filter");
            this.activateFilter(xab.getDiagram(), "hide.computed.component.exchanges.filter");
            this.activateFilter(xab.getDiagram(), "hide.computed.physical.links.filter");
            this.activateFilter(xab.getDiagram(), "hide.simplified.diagram.based.component.exchanges.filter");
            this.activateFilter(xab.getDiagram(), "hide.simplified.group.of.component.exchanges.filter");
            this.activateFilter(xab.getDiagram(), "hide.simplified.oriented.grouped.component.exchanges.filter");
        }
        DiagramHelper.refreshDiagram((DDiagram)xab.getDiagram());
    }
}

