/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.sirius.business.api.session.Session;
import org.junit.Assert;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SwitchFunctionalExchangesCategories
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testSwitchFunctionalExchangesCategories(context);
        this.testSwitchFunctionalExchangesCategories_BetweenParentFunctions(context);
    }

    void testSwitchFunctionalExchangesCategories(SessionContext context) {
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, "9674d2ca-16c0-4b98-99d5-f6b5421dd20a", "67aacd13-5813-4030-9fec-8a6b8ee536b0", "6c38aab1-8647-4e08-b97a-7956d98cbf14", "e70d2bca-a07b-47ba-bebf-ddb6d2dd157b", "f54ba750-a16d-4d74-89ba-3e1c6a63ad34");
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "cfc7de31-fef6-46b7-adf7-3bf6469db536", "b03f7d07-9f37-4982-a9b0-248d83ed48fe", "9cabe4bb-cd04-47b9-83b3-29ed69ac87e0", "2abe9989-bc2f-4c1d-b712-dc6c947ee57d", "a52fa49d-7ce5-47ed-8083-46bc64052b75");
        this.testOnXAB(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "0f857490-75f7-4cb8-97bf-cd3e57a669fa", "0e536993-3ef6-4061-9c59-6292a1b0a837", "c06f9196-de5f-43dc-baec-a75faf60fdfe", "653fdd80-43bf-4704-a9f3-54a76b22c2bf", "7ff702ec-0c47-4047-9a67-1869fb05b67b");
    }

    void testSwitchFunctionalExchangesCategories_BetweenParentFunctions(SessionContext context) {
        this.testOnXAB_BetweenParentFunctions(context, "[SAB] System", BlockArchitectureExt.Type.SA, "b76e3399-f2ed-4b8f-b23e-ea1194662d4b", "5cd86e0b-3cda-4c06-8c05-214b754bd4ce");
        this.testOnXAB_BetweenParentFunctions(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "eca4de89-fa15-4d1c-b9ee-5b9395b03117", "48a5e076-40d1-497f-8610-c6f24d818cf5");
        this.testOnXAB_BetweenParentFunctions(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "eb250acb-2da0-48df-b44a-0a1b7acfa645", "7f504ddd-e8ce-435c-8cea-0b602f575f8a");
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String categoryExchangeId, String exchangeId, String functionalChainId, String source, String target) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.switchFunctionalExchangesCategories(categoryExchangeId, true);
        diagram.refreshDiagram();
        diagram.hasntView(exchangeId);
        Assert.assertFalse((String)"The internal functional chain should be removed", (boolean)diagram.hasEdge(source, target, functionalChainId));
        diagram.switchFunctionalExchangesCategories(categoryExchangeId, false);
        diagram.hasntView(categoryExchangeId);
        Assert.assertTrue((String)"The internal functional chain should be added", (boolean)diagram.hasEdge(source, target, functionalChainId));
    }

    public void testOnXAB_BetweenParentFunctions(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String categoryExchangeId, String exchangeId) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.switchFunctionalExchangesCategories(categoryExchangeId, true);
        diagram.hasView(categoryExchangeId);
        diagram.hasntView(exchangeId);
        diagram.switchFunctionalExchangesCategories(categoryExchangeId, false);
        diagram.hasView(exchangeId);
        diagram.hasntView(categoryExchangeId);
        diagram.refreshDiagram();
        diagram.hasntView(categoryExchangeId);
    }
}

