/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.junit.Assert;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SwitchPhysicalLinksCategories
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, "53571fcc-bd97-44eb-86ca-961a2b8177e7", "ac6fba92-d508-421c-84bf-9b8eb87ddedc", "4797a74b-6abc-44aa-bb72-3516bb891a84", "e54c1773-1089-444b-9caa-2a5ca1fa9f5e", "d0a52770-b93d-4014-a4a7-54067cf0cfd4");
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "08d5ae0a-83d1-40fb-bec2-8beea4b86219", "343a04f9-1a83-4c09-b712-7cf783899849", "70b81a6e-1ef4-42d5-b94d-838068cd7658", "fff450d8-2760-4672-a390-4093b2f79721", "eaa53914-b3a5-49b4-9483-041b1e890c69");
        this.testOnXAB(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "2303dc43-b8fc-4bcb-a553-a9d4d63cef45", "6b7f564b-580d-445b-ac86-43a0be249007", "e1f1ad01-c08a-4cbb-bb7b-a7f364098608", "b424bc65-34a8-419a-97c5-e65ee3f69ca9", "4ed046fe-dba6-476e-856f-06a9250cf3d8");
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String categoryId, String linkId, String pathId, String source, String target) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        diagram.switchPhysicalLinksCategories(categoryId, true);
        diagram.refreshDiagram();
        diagram.hasntView(linkId);
        EObject sElement = diagram.getSessionContext().getSemanticElement(source);
        EObject tElement = diagram.getSessionContext().getSemanticElement(target);
        if (sElement != null && tElement != null && diagram.getView(sElement) != null && diagram.getView(tElement) != null) {
            Assert.assertFalse((String)"The internal physical path should be removed", (boolean)diagram.hasEdge(source, target, pathId));
        }
        diagram.switchPhysicalLinksCategories(categoryId, false);
        Assert.assertTrue((String)"The internal physical path should be added", (boolean)diagram.hasEdge(source, target, pathId));
        diagram.hasntView(categoryId);
        diagram.refreshDiagram();
        diagram.hasntView(categoryId);
    }
}

