/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.graph.InternalLinksGraph;
import org.polarsys.capella.core.model.helpers.graph.InvolvementGraph;
import org.polarsys.capella.core.sirius.analysis.cache.FunctionalChainCache;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.tools.ju.model.CompositeChains;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CompositeChainDisplay
extends CompositeChains {
    private final Collection<EObject> NO_GRAPH_CHECK = null;

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testComposite(context);
        this.testParentFunctions(context);
    }

    private void testComposite(SessionContext context) {
        DiagramContext lab = DiagramContext.getDiagram((SessionContext)context, (String)"_AOrTYDUMEemj_efF4T16lg");
        lab.refreshDiagram();
        FunctionalChain chain = (FunctionalChain)context.getSemanticElement("7b949ee1-223b-46ce-a8c7-fd2093028efd");
        InvolvementGraph graph = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
        Collection starts = graph.getNodes().values().stream().filter(arg_0 -> ((InvolvementGraph)graph).isInvolvingFunction(arg_0)).filter(arg_0 -> ((InvolvementGraph)graph).isStartingFunction(arg_0)).map(n -> ((FunctionalChainInvolvementFunction)n.getSemantic()).getInvolved()).map(EObject.class::cast).collect(Collectors.toSet());
        CompositeChainDisplay.assertTrue((String)"Chain doesn't have expected starts", (starts.size() == 2 ? 1 : 0) != 0);
        this.hasStyle(lab, "9dd1e5ba-58c8-4c3e-b80f-104bbc0f6088", starts);
        this.hasStyle(lab, "cb7c8a07-caaa-4f89-9c3d-43bc722a68fb", starts);
        Collection ends = graph.getNodes().values().stream().filter(arg_0 -> ((InvolvementGraph)graph).isInvolvingFunction(arg_0)).filter(arg_0 -> ((InvolvementGraph)graph).isEndingFunction(arg_0)).map(n -> ((FunctionalChainInvolvementFunction)n.getSemantic()).getInvolved()).map(EObject.class::cast).collect(Collectors.toSet());
        CompositeChainDisplay.assertTrue((String)"Chain doesn't have expected ends", (ends.size() == 3 ? 1 : 0) != 0);
        this.hasStyle(lab, "dfcf416b-195c-4d40-914a-8399997f0684", ends);
        this.hasStyle(lab, "e623170d-bf09-45b3-8121-efe915664e90", ends);
        this.hasStyle(lab, "446028d2-fb79-4a39-8386-dcdbefa94d6e", ends);
        this.hasntStyle(lab, "d0ca948a-1063-49d9-997e-0c333272d346", ends);
        this.hasntStyle(lab, "36038c9e-ab15-45af-a4f3-d773789373a7", ends);
        this.hasntStyle(lab, "680f0323-2523-4837-bf6c-3b14c36121db", ends);
        this.hasntStyle(lab, "1a673fc4-1fca-4c54-9dc0-971a78ab4335", ends);
        Collection exchanges = graph.getEdges().values().stream().filter(arg_0 -> ((InvolvementGraph)graph).isInvolvingFunctionalExchange(arg_0)).map(n -> ((FunctionalChainInvolvementLink)n.getSemantic()).getInvolved()).map(EObject.class::cast).collect(Collectors.toSet());
        this.hasStyle(lab, "670739ee-35da-4afb-8ff3-4f82518679fb", exchanges);
        this.hasStyle(lab, "21c3c15d-97b0-4df9-936b-e215e153921b", exchanges);
        this.hasStyle(lab, "b74ebf84-1126-4ff3-8938-657af26fbcc1", exchanges);
        this.hasStyle(lab, "f00dd799-fcde-442b-bc55-99cc786735c1", exchanges);
        this.hasStyle(lab, "2ef1ae07-0cd2-4951-ba00-0c6a48f1ea3b", exchanges);
        this.hasStyle(lab, "9f4234e5-12af-4556-ac61-6e86a72aa982", exchanges);
        this.hasStyle(lab, "11d24634-a580-43d9-9813-485b93edb205", exchanges);
        this.hasStyle(lab, "896eb099-b141-4c43-a71e-e81a30cac0f9", exchanges);
        this.hasntStyle(lab, "338359db-8473-4905-8db9-1f7ca58c2286", exchanges);
        this.hasntStyle(lab, "2346e002-311b-493b-8121-73965c49fe1c", exchanges);
        InternalLinksGraph internalLinks = FunctionalChainCache.getInstance().getInternalLinksGraph(graph);
        this.hasInternalLink(lab, internalLinks, "670739ee-35da-4afb-8ff3-4f82518679fb", "646c2172-686f-4ef0-9910-49434ee2541b");
        this.hasInternalLink(lab, internalLinks, "670739ee-35da-4afb-8ff3-4f82518679fb", "b74ebf84-1126-4ff3-8938-657af26fbcc1");
        this.hasInternalLink(lab, internalLinks, "21c3c15d-97b0-4df9-936b-e215e153921b", "646c2172-686f-4ef0-9910-49434ee2541b");
        this.hasInternalLink(lab, internalLinks, "21c3c15d-97b0-4df9-936b-e215e153921b", "b74ebf84-1126-4ff3-8938-657af26fbcc1");
        this.hasInternalLink(lab, internalLinks, "646c2172-686f-4ef0-9910-49434ee2541b", "2ef1ae07-0cd2-4951-ba00-0c6a48f1ea3b");
        this.hasInternalLink(lab, internalLinks, "646c2172-686f-4ef0-9910-49434ee2541b", "f00dd799-fcde-442b-bc55-99cc786735c1");
        this.hasInternalLink(lab, internalLinks, "2ef1ae07-0cd2-4951-ba00-0c6a48f1ea3b", "9f4234e5-12af-4556-ac61-6e86a72aa982");
        this.hasInternalLink(lab, internalLinks, "2ef1ae07-0cd2-4951-ba00-0c6a48f1ea3b", "11d24634-a580-43d9-9813-485b93edb205");
        this.hasInternalLink(lab, internalLinks, "f00dd799-fcde-442b-bc55-99cc786735c1", "896eb099-b141-4c43-a71e-e81a30cac0f9");
        CompositeChainDisplay.assertTrue((String)"Chain doesn't have expected internalLinks", (internalLinks.getEdges().values().size() == 9 ? 1 : 0) != 0);
    }

    private void testParentFunctions(SessionContext context) {
        DiagramContext lab = DiagramContext.getDiagram((SessionContext)context, (String)"_KVi6EDUqEem8pfs0hO7glw");
        lab.refreshDiagram();
        FunctionalChain chain = (FunctionalChain)context.getSemanticElement("7b949ee1-223b-46ce-a8c7-fd2093028efd");
        InvolvementGraph graph = FunctionalChainCache.getInstance().getInvolvementGraph(chain);
        Collection starts = graph.getNodes().values().stream().filter(arg_0 -> ((InvolvementGraph)graph).isInvolvingFunction(arg_0)).filter(arg_0 -> ((InvolvementGraph)graph).isStartingFunction(arg_0)).map(n -> ((FunctionalChainInvolvementFunction)n.getSemantic()).getInvolved()).map(EObject.class::cast).collect(Collectors.toSet());
        CompositeChainDisplay.assertTrue((starts.size() == 2 ? 1 : 0) != 0);
        CompositeChainDisplay.assertTrue((boolean)starts.contains(context.getSemanticElement("9dd1e5ba-58c8-4c3e-b80f-104bbc0f6088")));
        this.hasStyle(lab, "6d1c54ee-eb9c-4439-a5d7-d709a7da16e1", this.NO_GRAPH_CHECK);
        this.hasStyle(lab, "724b60a7-ff75-486e-ad5a-d81032f5b917", this.NO_GRAPH_CHECK);
        Collection ends = graph.getNodes().values().stream().filter(arg_0 -> ((InvolvementGraph)graph).isInvolvingFunction(arg_0)).filter(arg_0 -> ((InvolvementGraph)graph).isEndingFunction(arg_0)).map(n -> ((FunctionalChainInvolvementFunction)n.getSemantic()).getInvolved()).map(EObject.class::cast).collect(Collectors.toSet());
        CompositeChainDisplay.assertTrue((ends.size() == 3 ? 1 : 0) != 0);
        this.hasStyle(lab, "dfcf416b-195c-4d40-914a-8399997f0684", ends);
        this.hasntStyle(lab, "ef49c56f-e14c-4afb-a980-2f761bdb13af", this.NO_GRAPH_CHECK);
        this.hasStyle(lab, "270177ae-539a-45ac-9efd-1ad0053d5e15", this.NO_GRAPH_CHECK);
        this.hasStyle(lab, "81372a60-ec47-4601-a95d-bfd08da91f1c", this.NO_GRAPH_CHECK);
    }

    private void hasStyle(DiagramContext lab, String element, Collection<EObject> semantics) {
        DDiagramElement view = (DDiagramElement)lab.getView(element);
        if (semantics != this.NO_GRAPH_CHECK) {
            CompositeChainDisplay.assertTrue((boolean)semantics.contains(view.getTarget()));
        }
        String message = NLS.bind((String)"Element {0} shall be highlighted", (Object)element);
        if (view instanceof DNodeContainer) {
            CompositeChainDisplay.assertTrue((String)message, (((DNodeContainer)view).getOwnedStyle().getBorderSize() == 4 ? 1 : 0) != 0);
        } else if (view instanceof DEdge) {
            CompositeChainDisplay.assertTrue((String)message, (((DEdge)view).getOwnedStyle().getSize() == 4 ? 1 : 0) != 0);
        }
    }

    private void hasntStyle(DiagramContext lab, String element, Collection<EObject> semantics) {
        DDiagramElement view = (DDiagramElement)lab.getView(element);
        if (semantics != this.NO_GRAPH_CHECK) {
            CompositeChainDisplay.assertTrue((!semantics.contains(view.getTarget()) ? 1 : 0) != 0);
        }
        String message = NLS.bind((String)"Element {0} shall be normal", (Object)element);
        if (view instanceof DNodeContainer) {
            CompositeChainDisplay.assertTrue((String)message, (((DNodeContainer)view).getOwnedStyle().getBorderSize() == 1 ? 1 : 0) != 0);
        } else if (view instanceof DEdge) {
            CompositeChainDisplay.assertTrue((String)message, (((DEdge)view).getOwnedStyle().getSize() == 1 ? 1 : 0) != 0);
        }
    }

    private void hasInternalLink(DiagramContext context, InternalLinksGraph internalLinks, String startExchange, String endExchange) {
        FunctionalExchange start = (FunctionalExchange)context.getSessionContext().getSemanticElement(startExchange);
        FunctionalExchange end = (FunctionalExchange)context.getSessionContext().getSemanticElement(endExchange);
        String message = NLS.bind((String)"Missing internal link between {0} and {1}", (Object)start.getTarget().getName(), (Object)end.getTarget().getName());
        CompositeChainDisplay.assertTrue((String)message, (boolean)internalLinks.hasInternalLink((EObject)start.getTarget(), (EObject)end.getSource()));
        CompositeChainDisplay.assertTrue((String)message, (boolean)context.getDiagram().getEdges().stream().anyMatch(e -> e.getTarget() == internalLinks.getSemantic() && ((DSemanticDecorator)e.getSourceNode()).getTarget() == start.getTarget() && ((DSemanticDecorator)e.getTargetNode()).getTarget() == end.getSource()));
    }
}

