/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBDragAndDropTest
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "Operational RA Data Flow Diagram", BlockArchitectureExt.Type.OA, "1e2462db-b15c-4705-982d-93562d3e4094");
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA, "d560188d-bfa0-4a6b-a7ec-ef1a0a5a3415");
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA, "13a147ab-7547-4fbb-82ef-793acc9f164a");
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA, "4a3b3452-fe9f-4289-b25f-25f02d76428f");
    }

    private void testOnXDFBDiagram(SessionContext context, String diagramId, BlockArchitectureExt.Type diagramType, String rootFunctionId) {
        XDFBDiagram xdfbSetup = XDFBDiagram.createDiagram((SessionContext)context, (String)rootFunctionId);
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramId, (BlockArchitectureExt.Type)diagramType);
        String containerId = xdfb.getDiagramId();
        String function1Id = xdfbSetup.createContainer(xdfbSetup.getDiagramId(), XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = xdfb.createContainer(containerId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String constraintId = xdfbSetup.createConstraint("c1");
        xdfb.dragAndDropFunctionFromExplorer(function1Id, containerId);
        xdfb.dragAndDropAbstractFunction(function2Id, function1Id);
        if (diagramType != BlockArchitectureExt.Type.OA) {
            String function3Id = xdfb.createContainer(containerId, XDFBCreateContainerTools.CREATE_FUNCTION);
            xdfb.createEdge(function1Id, function3Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
            AbstractFunction f1 = (AbstractFunction)xdfb.getSessionContext().getSemanticElement(function1Id);
            EList ownedPins = f1.getOutputs();
            FunctionOutputPort outPort = (FunctionOutputPort)ownedPins.iterator().next();
            xdfb.dragAndDropFunctionPort(outPort.getId(), function2Id);
        }
        xdfb.dragAndDropConstraintsFromExplorer(constraintId, containerId);
    }
}

