/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBSetContextualElementsScenario
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "Operational RA Data Flow Diagram", BlockArchitectureExt.Type.OA);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    private void testOnXDFBDiagram(SessionContext context, String diagramId, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramId, (BlockArchitectureExt.Type)diagramType);
        String container1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String container2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{container1Id, container2Id});
        xdfb.setContextualElements(new String[]{container1Id, container2Id});
        DiagramHelper.refreshDiagram((DDiagram)xdfb.getDiagram());
        xdfb.hasViews(new String[]{container1Id, container2Id});
        xdfb.setContextualElements(new String[0]);
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{container1Id, container2Id});
    }
}

