/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.ShapeHelper;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBShowHideFunctionalExchange
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "Operational RA Data Flow Diagram", BlockArchitectureExt.Type.OA);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    protected void testOnXDFBDiagram(SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        DSemanticDecorator FE2view;
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        Diagram diagram = DiagramHelper.getDiagram((DDiagram)xdfb.getDiagram());
        String diagramId = xdfb.getDiagramId();
        String Function1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String Function2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String functionalExchangeToShowHideId = xdfb.createEdge(Function1Id, Function2Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        String functionalExchangeWhichShouldNotMoveId = xdfb.createEdge(Function2Id, Function1Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        DiagramHelper.setSynchronized((DDiagram)xdfb.getDiagram(), (boolean)false);
        xdfb.hideElements(Function1Id, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONAL_EXCHANGES, new String[]{functionalExchangeToShowHideId});
        if (diagramType != BlockArchitectureExt.Type.OA) {
            String outputPort = ((FunctionalExchange)xdfb.getSessionContext().getSemanticElement(functionalExchangeToShowHideId)).getSource().getId();
            String inputPort = ((FunctionalExchange)xdfb.getSessionContext().getSemanticElement(functionalExchangeToShowHideId)).getTarget().getId();
            xdfb.hasntView(inputPort);
            xdfb.hasntView(outputPort);
        }
        if ((FE2view = xdfb.getView(functionalExchangeWhichShouldNotMoveId)) instanceof DEdge) {
            PointList pointListBefore = ShapeHelper.getRelativePointListForDEdge((Diagram)diagram, (DDiagramElement)((DEdge)FE2view));
            Point firstPointBefore = pointListBefore.getFirstPoint();
            Point lastPointBefore = pointListBefore.getLastPoint();
            xdfb.showElements(Function1Id, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONAL_EXCHANGES, new String[]{functionalExchangeToShowHideId});
            FE2view = xdfb.getView(functionalExchangeWhichShouldNotMoveId);
            PointList pointListAfter = ShapeHelper.getRelativePointListForDEdge((Diagram)diagram, (DDiagramElement)((DEdge)FE2view));
            Point firstPointAfter = pointListAfter.getFirstPoint();
            Point lastPointAfter = pointListAfter.getLastPoint();
            XDFBShowHideFunctionalExchange.assertTrue((String)"FE2 must not move if we insert FE1", (firstPointAfter.getDistance(firstPointBefore) == 0.0 && lastPointAfter.getDistance(lastPointBefore) == 0.0 ? 1 : 0) != 0);
        } else {
            XDFBShowHideFunctionalExchange.fail((String)"FE2 must be visible and must be a DEdge");
        }
        DiagramHelper.setSynchronized((DDiagram)xdfb.getDiagram(), (boolean)true);
    }
}

