/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBSwitchFunctionalExchangeCategory
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    private void testOnXDFBDiagram(SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        this.testSwitchFunctionalExchangesCategories(xdfb, diagramType);
        this.testSwitchFunctionalExchangesCategoriesOnChild(xdfb, diagramType);
    }

    private void testSwitchFunctionalExchangesCategories(XDFBDiagram xdfb, BlockArchitectureExt.Type diagramType) {
        String diagramId = xdfb.getDiagramId();
        String exchangeCategoryID = null;
        String function5Id = null;
        String function6Id = null;
        switch (diagramType) {
            case SA: {
                exchangeCategoryID = "14bb40fb-6356-4fc0-a04d-197e969a7fb7";
                function5Id = "9719e641-42fa-4571-a3a1-71d189d8dbca";
                function6Id = "cb013381-cb60-46e9-9db0-46819e738b1d";
                break;
            }
            case LA: {
                exchangeCategoryID = "e8552647-7e45-4c69-9450-410dd807005c";
                function5Id = "748c6678-58dd-4d8b-a8e7-eaf6b32d5530";
                function6Id = "626819b9-6526-4fd4-8c9b-7b211447ba46";
                break;
            }
            case PA: {
                exchangeCategoryID = "dbe5bfdb-9678-4b1c-b258-033045af8110";
                function5Id = "b9dce68d-74e2-4ef4-a73d-025d97553601";
                function6Id = "c57465b9-e633-4b60-90bf-356d72fff39f";
                break;
            }
        }
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{function5Id, function6Id});
        xdfb.switchInFunctionalExchangesCategories(exchangeCategoryID);
        xdfb.switchOutFunctionalExchangesCategories(exchangeCategoryID);
    }

    private void testSwitchFunctionalExchangesCategoriesOnChild(XDFBDiagram xdfb, BlockArchitectureExt.Type diagramType) {
        String diagramId = xdfb.getDiagramId();
        String exchangeCategoryID = null;
        String parentId = null;
        String childId = null;
        String targetId = null;
        switch (diagramType) {
            case SA: {
                exchangeCategoryID = "d3814040-7dd3-449c-b07c-0f84a5fe3732";
                parentId = "ea873320-04e5-4845-9b2b-fdbdfe3fc1ea";
                childId = "1a76d607-2b80-432e-97b1-06ef5fd29f50";
                targetId = "a650ff02-0217-4da8-a4d1-c28d4f581b6a";
                break;
            }
            case LA: {
                exchangeCategoryID = "6ca545eb-25eb-4256-a9f9-8ae94e7f74b6";
                parentId = "f1090924-7595-4799-8d3a-774784ffe203";
                childId = "3c5764b9-1d2b-4521-a74f-02c4ec858bdb";
                targetId = "d38f9252-4ba5-4cbb-89a6-e047a983297b";
                break;
            }
            case PA: {
                exchangeCategoryID = "d6c19f5a-f5aa-4e45-b7bc-67269c2389bd";
                parentId = "2d87060d-309a-4499-9eb6-05d4afacb084";
                childId = "a412ab00-667c-4a86-9836-2bba8a57ec10";
                targetId = "b74d64ba-54e1-4ce9-ada2-21ee9972e830";
                break;
            }
        }
        xdfb.showElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{parentId, childId, targetId});
        xdfb.switchInFunctionalExchangesCategories(exchangeCategoryID);
        xdfb.hideElements(diagramId, XDFBInsertRemoveTools.INSERT_REMOVE_FUNCTIONS, new String[]{childId});
        xdfb.switchOutFunctionalExchangesCategories(exchangeCategoryID);
        xdfb.switchInFunctionalExchangesCategories(exchangeCategoryID);
    }
}

