/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateNodeTools;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.XDFBToolsTestingModel;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBToolReconnect
extends XDFBToolsTestingModel {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXDFBDiagram(context, "System RF Data Flow Diagram", BlockArchitectureExt.Type.SA);
        this.testOnXDFBDiagram(context, "Logical RF Data Flow Diagram", BlockArchitectureExt.Type.LA);
        this.testOnXDFBDiagram(context, "Physical RF Data Flow Diagram", BlockArchitectureExt.Type.PA);
    }

    private void testOnXDFBDiagram(SessionContext context, String diagramName, BlockArchitectureExt.Type diagramType) {
        XDFBDiagram xdfb = XDFBDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)diagramType);
        String diagramId = xdfb.getDiagramId();
        String function1Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String function2Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
        String edgeToReconnectId = xdfb.createEdge(function1Id, function2Id, XDFBCreateEdgeTools.CREATE_FUNCTIONAL_EXCHANGE);
        if (diagramType != BlockArchitectureExt.Type.OA) {
            String outputPortOnFunction1Id = ((FunctionalExchange)xdfb.getSessionContext().getSemanticElement(edgeToReconnectId)).getSource().getId();
            String inputPortOnFunction2Id = ((FunctionalExchange)xdfb.getSessionContext().getSemanticElement(edgeToReconnectId)).getTarget().getId();
            String inputPort1OnFunction1Id = xdfb.createNode(function1Id, XDFBCreateNodeTools.CREATE_INPUT_PORT);
            String outputPort2OnFunction1Id = xdfb.createNode(function1Id, XDFBCreateNodeTools.CREATE_OUTPUT_PORT);
            String inputPort2OnFunction2Id = xdfb.createNode(function2Id, XDFBCreateNodeTools.CREATE_INPUT_PORT);
            String outputPort1OnFunction2Id = xdfb.createNode(function2Id, XDFBCreateNodeTools.CREATE_OUTPUT_PORT);
            xdfb.reconnectFunctionalExchange(edgeToReconnectId, outputPortOnFunction1Id, outputPort2OnFunction1Id);
            xdfb.reconnectFunctionalExchange(edgeToReconnectId, inputPortOnFunction2Id, inputPort2OnFunction2Id);
            xdfb.cannotReconnectFunctionalExchange(edgeToReconnectId, outputPort2OnFunction1Id, inputPort1OnFunction1Id);
            xdfb.cannotReconnectFunctionalExchange(edgeToReconnectId, inputPort2OnFunction2Id, outputPort1OnFunction2Id);
        } else {
            String function3Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
            String function4Id = xdfb.createContainer(diagramId, XDFBCreateContainerTools.CREATE_FUNCTION);
            xdfb.reconnectFunctionalExchange(edgeToReconnectId, function1Id, function3Id);
            xdfb.reconnectFunctionalExchange(edgeToReconnectId, function2Id, function4Id);
            String constraintId = xdfb.createNode(diagramId, XDFBCreateNodeTools.CREATE_CONSTRAINT);
            xdfb.cannotReconnectFunctionalExchange(edgeToReconnectId, function1Id, constraintId);
            xdfb.cannotReconnectFunctionalExchange(edgeToReconnectId, function2Id, constraintId);
        }
    }
}

