/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.doc.ju;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class StyleCheckTestCase
extends BasicTestCase {
    public void test() throws Exception {
        Bundle[] bundles;
        ArrayList<Bundle> docPlugins = new ArrayList<Bundle>();
        ArrayList<URL> invalidHtmls = new ArrayList<URL>();
        BundleContext ctx = FrameworkUtil.getBundle(StyleCheckTestCase.class).getBundleContext();
        Bundle[] bundleArray = bundles = ctx.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (this.isDocPlugin(bundle)) {
                docPlugins.add(bundle);
            }
            ++n2;
        }
        String errMsg = "The following documents do not include CSS style: ";
        for (Bundle docPlugin : docPlugins) {
            String bundleErrMsg = "In plugin " + docPlugin.getSymbolicName() + ": ";
            Enumeration entries = docPlugin.findEntries("html", "*.html", true);
            boolean hasInvalidHtml = false;
            while (entries.hasMoreElements()) {
                URL htmlURL = (URL)entries.nextElement();
                if (this.isExluded(htmlURL) || this.doesHtmlDocIncludeStyle(htmlURL)) continue;
                invalidHtmls.add(htmlURL);
                bundleErrMsg = String.valueOf(bundleErrMsg) + htmlURL.getFile() + ", ";
                hasInvalidHtml = true;
            }
            if (!hasInvalidHtml) continue;
            errMsg = String.valueOf(errMsg) + bundleErrMsg.substring(0, bundleErrMsg.length() - 2) + ". ";
        }
        StyleCheckTestCase.assertTrue((String)errMsg, (invalidHtmls.size() == 0 ? 1 : 0) != 0);
    }

    protected boolean isDocPlugin(Bundle bundle) {
        return bundle.getSymbolicName().startsWith("org.polarsys.capella") && bundle.getSymbolicName().endsWith("doc");
    }

    public boolean doesHtmlDocIncludeStyle(URL htmlURL) throws IOException {
        String inputLine;
        boolean result = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(htmlURL.openStream()));
        while ((inputLine = in.readLine()) != null) {
            if (!inputLine.contains(this.getCSSFile())) continue;
            result = true;
        }
        in.close();
        return result;
    }

    protected String getCSSFile() {
        return "PLUGINS_ROOT/org.polarsys.capella.doc/html/styles.css";
    }

    protected boolean isExluded(URL htmlURL) {
        return htmlURL.getFile().startsWith("/html/api-docs/javadoc");
    }
}

