/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.test.fragmentation.ju.messages.FragmentationMessages;
import org.polarsys.capella.test.fragmentation.ju.utils.AbstractFragmentationTest;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentUtils;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class FragmentTest
extends AbstractFragmentationTest {
    public FragmentTest(SessionContext context, String objectId) {
        super(context, objectId);
    }

    public FragmentTest(SessionContext context, EObject object) {
        super(context, object);
    }

    public void fragmentTest() {
        EObject objectToFragment = this.getTargetObject();
        Assert.assertNull((String)NLS.bind((String)FragmentationMessages.abstractFragmentTest_isAlreadyFragmented, (Object)EObjectExt.getText((EObject)objectToFragment)), (Object)FragmentUtils.getDirectResource(objectToFragment));
        int numberOfProperChildren = FragmentUtils.getNumberOfProperEObjects(objectToFragment);
        Map<EObject, Integer> eObjectRefCount = FragmentUtils.getProperContentsRefCount(objectToFragment);
        new GuiActions().fragment((CapellaElement)objectToFragment, this._dRepresentations);
        this.postFragmentChecks(objectToFragment, numberOfProperChildren, eObjectRefCount);
    }

    protected void postFragmentChecks(EObject objectToFragment, int numberOfProperChildren, Map<EObject, Integer> eObjectRefCount) {
        Resource newResource = FragmentUtils.getDirectResource(objectToFragment);
        Assert.assertNotNull((String)NLS.bind((String)FragmentationMessages.abstractFragmentTest_hasNotItsOwnResource, (Object)EObjectExt.getText((EObject)objectToFragment)), (Object)newResource);
        FragmentUtils.checkEResource(objectToFragment, newResource);
        int newNumberOfProperChildren = FragmentUtils.getNumberOfProperEObjects(objectToFragment);
        Assert.assertEquals((String)NLS.bind((String)FragmentationMessages.abstractFragmentTest_hasNotSameNumbersOfchildrenAfterFragmentation, (Object)EObjectExt.getText((EObject)objectToFragment)), (long)numberOfProperChildren, (long)newNumberOfProperChildren);
        Map<EObject, Integer> newEObjectRefCount = FragmentUtils.getProperContentsRefCount(objectToFragment);
        FragmentUtils.compareRefCountForTest(objectToFragment, eObjectRefCount, newEObjectRefCount, true);
    }

    protected void postRunTest() {
        if (this.isThereAnyDRepresentationToMove()) {
            Set<Resource> newAIRDresources = FragmentUtils.getAirdResourceWithAnalysisOn(this.getTargetObject());
            for (DRepresentationDescriptor drepresentation : this.getDRepresentationDescriptorsToMove()) {
                Resource newAIRDresource;
                if (!newAIRDresources.contains(drepresentation.eResource())) {
                    Assert.assertTrue((String)NLS.bind((String)FragmentationMessages.abstractFragmentationTest_wrongAirdresourceAfterOps, (Object)drepresentation.getName()), (boolean)false);
                }
                boolean isnewAIRDresourceExist = WorkspaceSynchronizer.getFile((Resource)(newAIRDresource = drepresentation.eResource())) != null;
                Assert.assertTrue((String)("The new fragment '" + newAIRDresource.getURI().toString() + "' is not create"), (boolean)isnewAIRDresourceExist);
            }
        }
        this._eObject = null;
        this._dRepresentations = null;
        if (this._oldAIRDResources != null) {
            this._oldAIRDResources.clear();
        }
    }

    public Object getResult() {
        return null;
    }

    protected void runTest() {
        this.fragmentTest();
    }
}

