/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.massactions.ju.testcases.view.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommand;
import org.polarsys.capella.test.massactions.ju.helpers.LayerHelper;
import org.polarsys.capella.test.massactions.ju.helpers.ViewHelper;
import org.polarsys.capella.test.massactions.ju.model.AbstractCapellaMATestCase;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.view.MAView;
import org.polarsys.kitalpha.massactions.visualize.MVView;

public class ColumnReorderTest
extends AbstractCapellaMATestCase {
    @Override
    public void performTest() throws Exception {
        MEView editionView = ViewHelper.getActiveMEView();
        MVView visualizationView = ViewHelper.getActiveMVView();
        this.testColumnReorder((MAView)editionView);
        this.testColumnReorder((MAView)visualizationView);
    }

    private void testColumnReorder(MAView view) {
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(this.getObject("3688cf59-97ee-4446-8041-7941cee6c767"));
        view.dataChanged(data);
        List<String> columnNamesToReorder = Arrays.asList("name", "visibleInDoc", "ordered", "unique");
        IMAGridLayer gridLayer = LayerHelper.extractGridLayer(view);
        IMABodyLayer bodyLayer = gridLayer.getBodyLayer();
        IMAColumnPropertyAccessor columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
        ColumnHideShowLayer columnHideShowLayer = bodyLayer.getColumnHideShowLayer();
        ColumnReorderLayer columnReorderLayer = bodyLayer.getColumnReorderLayer();
        List beforeIndexOrder = Collections.emptyList();
        List afterIndexOrder = Collections.emptyList();
        List expectedIndexOrder = IntStream.range(0, columnPropertyAccessor.getColumnCount()).boxed().collect(Collectors.toList());
        beforeIndexOrder = new ArrayList(columnReorderLayer.getColumnIndexOrder());
        ColumnReorderTest.assertEquals(expectedIndexOrder, beforeIndexOrder);
        for (String columnName : columnNamesToReorder) {
            int columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            int columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
            int newColumnPosition = 0;
            columnReorderLayer.doCommand((ILayerCommand)new ColumnReorderStartCommand((ILayer)columnReorderLayer, columnPosition));
            columnReorderLayer.doCommand((ILayerCommand)new ColumnReorderEndCommand((ILayer)columnReorderLayer, newColumnPosition));
        }
        afterIndexOrder = new ArrayList(columnReorderLayer.getColumnIndexOrder());
        ColumnReorderTest.assertFalse((boolean)afterIndexOrder.isEmpty());
        ColumnReorderTest.assertNotSame(afterIndexOrder, beforeIndexOrder);
        beforeIndexOrder = new ArrayList(columnReorderLayer.getColumnIndexOrder());
        data.add(this.getObject("3398fdbf-3415-4d03-a457-477324d2e091"));
        view.dataChanged(data);
        afterIndexOrder = new ArrayList(columnReorderLayer.getColumnIndexOrder());
        ColumnReorderTest.assertEquals(beforeIndexOrder, afterIndexOrder);
        beforeIndexOrder = new ArrayList(afterIndexOrder);
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        ArrayList finalAfterIndexOrder = new ArrayList(columnReorderLayer.getColumnIndexOrder());
        List collected = beforeIndexOrder.stream().filter(index -> finalAfterIndexOrder.contains(index)).collect(Collectors.toList());
        ColumnReorderTest.assertEquals(collected, finalAfterIndexOrder);
        ViewHelper.resetViews(view);
    }
}

