/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.massactions.ju.testcases.view.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;
import org.polarsys.capella.test.massactions.ju.helpers.LayerHelper;
import org.polarsys.capella.test.massactions.ju.helpers.ViewHelper;
import org.polarsys.capella.test.massactions.ju.model.AbstractCapellaMATestCase;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.column.IMAColumnHeaderLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.view.MAView;
import org.polarsys.kitalpha.massactions.visualize.MVView;

public class ColumnSortTest
extends AbstractCapellaMATestCase {
    @Override
    public void performTest() throws Exception {
        MEView editionView = ViewHelper.getActiveMEView();
        MVView visualizationView = ViewHelper.getActiveMVView();
        this.testColumnSort((MAView)editionView);
        this.testColumnSort((MAView)visualizationView);
    }

    public void testColumnSort(MAView view) {
        int columnPosition;
        int columnIndex;
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(this.getObject("3688cf59-97ee-4446-8041-7941cee6c767"));
        view.dataChanged(data);
        List<String> columnNamesToSort = Arrays.asList("name", "visibleInDoc", "ordered", "unique");
        IMAGridLayer gridLayer = LayerHelper.extractGridLayer(view);
        IMABodyLayer bodyLayer = gridLayer.getBodyLayer();
        IMAColumnHeaderLayer columnHeaderLayer = gridLayer.getColumnHeaderLayer();
        IMAColumnPropertyAccessor columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
        ColumnHideShowLayer columnHideShowLayer = bodyLayer.getColumnHideShowLayer();
        SortHeaderLayer sortHeaderLayer = columnHeaderLayer.getSortHeaderLayer();
        ISortModel sortModel = sortHeaderLayer.getSortModel();
        Set beforeSortedColumns = Collections.emptySet();
        Collection<Object> beforeSortDirectionEnums = Collections.emptySet();
        Set afterSortedColumns = Collections.emptySet();
        Collection<Object> afterSortDirectionEnums = Collections.emptySet();
        for (String columnName : columnNamesToSort) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
            ColumnSortTest.assertFalse((boolean)sortModel.isColumnIndexSorted(columnIndex));
            sortHeaderLayer.doCommand((ILayerCommand)new SortColumnCommand((ILayer)sortHeaderLayer, columnPosition));
            ColumnSortTest.assertTrue((boolean)sortModel.isColumnIndexSorted(columnIndex));
        }
        beforeSortedColumns = new HashSet(sortModel.getSortedColumnIndexes());
        beforeSortDirectionEnums = beforeSortedColumns.stream().map(arg_0 -> ((ISortModel)sortModel).getSortDirection(arg_0)).collect(Collectors.toList());
        data.add(this.getObject("3398fdbf-3415-4d03-a457-477324d2e091"));
        view.dataChanged(data);
        afterSortedColumns = new HashSet(sortModel.getSortedColumnIndexes());
        afterSortDirectionEnums = afterSortedColumns.stream().map(arg_0 -> ((ISortModel)sortModel).getSortDirection(arg_0)).collect(Collectors.toList());
        ColumnSortTest.assertFalse((boolean)beforeSortedColumns.isEmpty());
        ColumnSortTest.assertFalse((boolean)afterSortedColumns.isEmpty());
        ColumnSortTest.assertEquals(beforeSortedColumns, afterSortedColumns);
        ColumnSortTest.assertFalse((boolean)beforeSortDirectionEnums.isEmpty());
        ColumnSortTest.assertFalse((boolean)afterSortDirectionEnums.isEmpty());
        ColumnSortTest.assertEquals(beforeSortDirectionEnums, afterSortDirectionEnums);
        columnIndex = columnPropertyAccessor.getColumnIndex("name");
        columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
        sortHeaderLayer.doCommand((ILayerCommand)new SortColumnCommand((ILayer)sortHeaderLayer, columnPosition));
        ColumnSortTest.assertTrue((boolean)sortModel.isColumnIndexSorted(columnIndex));
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        columnIndex = columnPropertyAccessor.getColumnIndex("name");
        columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
        ColumnSortTest.assertTrue((boolean)sortModel.isColumnIndexSorted(columnIndex));
        ColumnSortTest.assertEquals((int)1, (int)sortModel.getSortedColumnIndexes().size());
        ViewHelper.resetViews(view);
        ColumnSortTest.assertTrue((boolean)data.remove(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1")));
        view.dataChanged(data);
        gridLayer = LayerHelper.extractGridLayer(view);
        bodyLayer = gridLayer.getBodyLayer();
        columnHeaderLayer = gridLayer.getColumnHeaderLayer();
        columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
        columnHideShowLayer = bodyLayer.getColumnHideShowLayer();
        sortHeaderLayer = columnHeaderLayer.getSortHeaderLayer();
        sortModel = sortHeaderLayer.getSortModel();
        columnIndex = columnPropertyAccessor.getColumnIndex("unique");
        columnPosition = columnHideShowLayer.getColumnPositionByIndex(columnIndex);
        sortHeaderLayer.doCommand((ILayerCommand)new SortColumnCommand((ILayer)sortHeaderLayer, columnPosition));
        ColumnSortTest.assertTrue((boolean)sortModel.isColumnIndexSorted(columnIndex));
        ColumnSortTest.assertEquals((int)1, (int)sortModel.getSortedColumnIndexes().size());
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        ColumnSortTest.assertEquals((int)-1, (int)columnPropertyAccessor.getColumnIndex("unique"));
        ColumnSortTest.assertTrue((boolean)sortModel.getSortedColumnIndexes().isEmpty());
        ViewHelper.resetViews(view);
    }
}

