/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public abstract class AbstractFiltersMigrationTest
extends BasicTestCase {
    private static final String ERROR_MSG = "Assertion error for model {0} diagram {1} and filter {2}";
    BiPredicate<List<FilterDescription>, FilterDescription> isFilterEnabledPredicate = (activatedFilters, filterCandidate) -> activatedFilters.contains(filterCandidate);
    BiPredicate<List<FilterDescription>, FilterDescription> isFilterNotEnabledPredicate = (activatedFilters, filterCandidate) -> !activatedFilters.contains(filterCandidate);

    protected void assertFilterEnabledAfterMigration(String modelName, Collection<String> errors) {
        this.assertFilterPredicateAfterMigration(modelName, this.isFilterEnabledPredicate, errors);
    }

    protected void assertFilterNotEnabledAfterMigration(String modelName, Collection<String> errors) {
        this.assertFilterPredicateAfterMigration(modelName, this.isFilterNotEnabledPredicate, errors);
    }

    private void assertFilterPredicateAfterMigration(String modelName, BiPredicate<List<FilterDescription>, FilterDescription> filterPredicate, Collection<String> errors) {
        IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)modelName);
        MigrationHelper.migrateProject(project);
        Session session = this.getSessionForTestModel(modelName);
        AbstractFiltersMigrationTest.assertNotNull((Object)session);
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation representation : allRepresentations) {
            if (!(representation instanceof DSemanticDiagram)) continue;
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            List<FilterDescription> expectedFilters = this.getExpectedFilters(diagram);
            EList activatedFilters = diagram.getActivatedFilters();
            for (FilterDescription expectedFilter : expectedFilters) {
                if (filterPredicate.test((List<FilterDescription>)activatedFilters, expectedFilter)) continue;
                Object[] errorArgs = new String[]{modelName, diagram.getName(), expectedFilter.getName()};
                String errorMsg = NLS.bind((String)ERROR_MSG, (Object[])errorArgs);
                errors.add(errorMsg);
            }
        }
        GuiActions.closeSession((Session)session);
    }

    private List<FilterDescription> getExpectedFilters(DSemanticDiagram diagram) {
        DiagramDescription description = diagram.getDescription();
        List<FilterDescription> expectedFilters = description.getFilters().stream().filter(filter -> this.getFilterCandidatesNames().contains(filter.getName())).collect(Collectors.toList());
        return expectedFilters;
    }

    public abstract Set<String> getFilterCandidatesNames();
}

