/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EAttributeValuePresence;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.impl.scopes.FragmentedModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.capella.core.compare.CapellaDiffPolicy;
import org.polarsys.capella.core.compare.CapellaMatchPolicy;
import org.polarsys.capella.core.compare.CapellaMergePolicy;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class FunctionalChainNonRegressionTest
extends BasicTestCase {
    private static final String SOURCE_MODELV4 = "FunctionalChains_1_4_2";
    private static final String SOURCE_MODELV5 = "FunctionalChains_5_2_0";
    private static final String SOURCE_MODEL = "FunctionalChains";
    private static final String TARGET_MIGRATED_MODEL = "FunctionalChainsNonRegression";
    private static final String SOURCE_MODEL_RESOURCE = "FunctionalChains.capella";
    private static final String TARGET_MIGRATED_MODEL_RESOURCE = "FunctionalChainsNonRegression.capella";
    private IProject sourceModelProjectV4;
    private IProject sourceModelProjectV5;
    private IProject targetMigratedModelProject;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(SOURCE_MODELV4, SOURCE_MODELV5, TARGET_MIGRATED_MODEL);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceModelProjectV4 = IResourceHelpers.getEclipseProjectInWorkspace((String)SOURCE_MODELV4);
        this.sourceModelProjectV5 = IResourceHelpers.getEclipseProjectInWorkspace((String)SOURCE_MODELV5);
        this.targetMigratedModelProject = IResourceHelpers.getEclipseProjectInWorkspace((String)TARGET_MIGRATED_MODEL);
    }

    public void test() throws Exception {
        if (this.sourceModelProjectV4.exists() && this.sourceModelProjectV5.exists() && this.targetMigratedModelProject.exists()) {
            MigrationHelper.migrateProject(this.sourceModelProjectV4);
            MigrationHelper.migrateProject(this.sourceModelProjectV5);
            Resource targetResource = this.getResourceToTest(this.targetMigratedModelProject, TARGET_MIGRATED_MODEL_RESOURCE);
            FragmentedModelScope targetProjectScope = new FragmentedModelScope(targetResource, true);
            this.assessExpectedDifferences(this.sourceModelProjectV4, (IEditableModelScope)targetProjectScope);
            this.assessExpectedDifferences(this.sourceModelProjectV5, (IEditableModelScope)targetProjectScope);
        }
    }

    private void assessExpectedDifferences(IProject sourceModelProject, IEditableModelScope targetProjectScope) {
        Resource sourceResource = this.getResourceToTest(sourceModelProject, SOURCE_MODEL_RESOURCE);
        FragmentedModelScope sourceProjectScope = new FragmentedModelScope(sourceResource, true);
        EComparisonImpl comparison = new EComparisonImpl((IEditableTreeDataScope)sourceProjectScope, (IEditableTreeDataScope)targetProjectScope);
        comparison.compute((IMatchPolicy)new CapellaMatchPolicy(), (IDiffPolicy)new CapellaDiffPolicy(){

            protected boolean doConsiderOrdered(EStructuralFeature feature_p) {
                if (feature_p.equals(FaPackage.Literals.FUNCTIONAL_CHAIN__OWNED_FUNCTIONAL_CHAIN_INVOLVEMENTS)) {
                    return false;
                }
                return super.doConsiderOrdered(feature_p);
            }
        }, (IMergePolicy)new CapellaMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
        this.assertOnlyProjectNameDifference(comparison.getDifferences(Role.TARGET), SOURCE_MODEL);
        this.assertOnlyProjectNameDifference(comparison.getDifferences(Role.REFERENCE), TARGET_MIGRATED_MODEL);
    }

    public void assertOnlyProjectNameDifference(Collection<IDifference<EObject>> differences, String projectName) {
        FunctionalChainNonRegressionTest.assertEquals((int)1, (int)differences.size());
        IDifference<EObject> difference = differences.iterator().next();
        FunctionalChainNonRegressionTest.assertTrue((boolean)(difference instanceof EAttributeValuePresence));
        FunctionalChainNonRegressionTest.assertEquals((Object)((EAttributeValuePresence)difference).getValue(), (Object)projectName);
    }

    private Resource getResourceToTest(IProject project, String fileName) {
        IFile file = project.getFile(fileName);
        URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        return resourceSet.getResource(fileURI, true);
    }
}

