/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class ImagePathInRichTextAttributeMigrationTest
extends BasicTestCase {
    private static final String CAPELLA_PNG = "capella.png";
    private static final String SOURCE_MODEL = "ImagePath InRichTextAttribute";
    String HTML_IMAGE_PATH_PATTERN_HTTP = "<img.*?src=\"https?://(.*?)\".*?/>";
    String HTML_IMAGE_PATH_PATTERN_BASE64 = "<img.*?src=\"ImagePath InRichTextAttribute/images/(.*?)\".*?/>";
    String HTML_IMAGE_PATH_PATTERN_COPIED = "<img.*?src=\"(ImagePath InRichTextAttribute/images/capella[0-9]*?\\.png)\".*?/>";
    String HTML_IMAGE_PATH_PATTERN_RELATIVE = "<img.*?src=(\"ImagePath InRichTextAttribute/capella\\.png\").*?/>";
    String HTML_IMAGE_INVALID_ABSOLUTE_PATH = "C:\\INVALID\\PATH\\IMAGE.png";
    String HTML_IMAGE_INVALID_RELATIVE_PATH = "/RELATIVE_IMAGE_NOT_FOUND.png";
    private static final String OA_ELEMENT_ID = "b302cb2c-9ebb-4a79-a1cb-2cf8e46fe51b";
    private IProject sourceModelProject;
    private ILogListener logListener;
    private List<IStatus> statuses = new ArrayList<IStatus>();

    public List<String> getRequiredTestModels() {
        return Arrays.asList(SOURCE_MODEL);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sourceModelProject = IResourceHelpers.getEclipseProjectInWorkspace((String)SOURCE_MODEL);
        this.logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                ImagePathInRichTextAttributeMigrationTest.this.statuses.add(status);
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
    }

    public void test() throws Exception {
        if (this.sourceModelProject.exists()) {
            ImagePathInRichTextAttributeMigrationTest.assertTrue((String)"Bad test data: there should be no images folder", (Arrays.asList(this.sourceModelProject.members()).stream().filter(IFolder.class::isInstance).count() == 0L ? 1 : 0) != 0);
            this.statuses.clear();
            MigrationHelper.migrateProject(this.sourceModelProject);
            this.checkLogs();
            Session session = this.getSessionForTestModel(SOURCE_MODEL);
            SessionContext context = new SessionContext(session);
            OperationalActivity oa = (OperationalActivity)context.getSemanticElement(OA_ELEMENT_ID);
            this.checkBase64StringMigration(session, oa);
            this.checkAbsolutePathMigration(session, oa);
            this.checkPathWithHttp(session, oa);
            this.checkProjectRelativePathMigration(oa);
        }
    }

    private void checkPathWithHttp(Session session, OperationalActivity oa) {
        Pattern pattern = Pattern.compile(this.HTML_IMAGE_PATH_PATTERN_HTTP);
        Matcher matcher = pattern.matcher(oa.getDescription());
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)("The path to the image has not been found with pattern " + this.HTML_IMAGE_PATH_PATTERN_HTTP), (matcher.find() && matcher.find() ? 1 : 0) != 0);
    }

    private void checkBase64StringMigration(Session session, OperationalActivity oa) throws CoreException {
        List folders = Arrays.asList(this.sourceModelProject.members()).stream().filter(IFolder.class::isInstance).map(IFolder.class::cast).collect(Collectors.toList());
        ImagePathInRichTextAttributeMigrationTest.assertEquals((int)1, (int)folders.size());
        ImagePathInRichTextAttributeMigrationTest.assertEquals((String)"Bad imagefolder name", (String)"images", (String)((IFolder)folders.get(0)).getName());
        IResource[] members = ((IFolder)folders.get(0)).members();
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)"There should be only two images in the images folder: one from the OA description and one from the diagram description", (members.length == 2 && members[0] instanceof IFile ? 1 : 0) != 0);
        String imageName = members[0].getName();
        Pattern pattern = Pattern.compile(this.HTML_IMAGE_PATH_PATTERN_BASE64);
        Matcher matcher = pattern.matcher(oa.getDescription());
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)("The path to the image has not been found with pattern " + this.HTML_IMAGE_PATH_PATTERN_BASE64), (boolean)matcher.find());
        ImagePathInRichTextAttributeMigrationTest.assertEquals((String)imageName, (String)matcher.group(1));
        ImagePathInRichTextAttributeMigrationTest.assertFalse((String)("There should not be any other match for the pattern " + this.HTML_IMAGE_PATH_PATTERN_BASE64), (boolean)matcher.find());
    }

    private void checkAbsolutePathMigration(Session session, final OperationalActivity oa) throws CoreException {
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)(String.valueOf(this.HTML_IMAGE_INVALID_ABSOLUTE_PATH) + " should have been found because this path does not lead to an existing file"), (boolean)oa.getDescription().contains(this.HTML_IMAGE_INVALID_ABSOLUTE_PATH));
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

            protected void doExecute() {
                String newDescription = "";
                try {
                    newDescription = oa.getDescription().replace("file:/" + ImagePathInRichTextAttributeMigrationTest.this.HTML_IMAGE_INVALID_ABSOLUTE_PATH, ImagePathInRichTextAttributeMigrationTest.this.sourceModelProject.getFile(ImagePathInRichTextAttributeMigrationTest.CAPELLA_PNG).getLocationURI().toURL().toExternalForm());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                oa.setDescription(newDescription);
            }
        });
        session.save((IProgressMonitor)new NullProgressMonitor());
        session.close((IProgressMonitor)new NullProgressMonitor());
        MigrationHelper.migrateProject(this.sourceModelProject);
        session = this.getSessionForTestModel(SOURCE_MODEL);
        SessionContext context = new SessionContext(session);
        OperationalActivity oa2 = (OperationalActivity)context.getSemanticElement(OA_ELEMENT_ID);
        String expectedPath = "ImagePath InRichTextAttribute/images/capella.png";
        Pattern pattern = Pattern.compile(this.HTML_IMAGE_PATH_PATTERN_COPIED);
        Matcher matcher = pattern.matcher(oa2.getDescription());
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)("file:/xxxx/junit-workspace/ImagePath%20InRichTextAttribute/capella.png  should have been migrated into " + expectedPath), (boolean)matcher.find());
        long nbImageFiles = Arrays.asList(this.sourceModelProject.getFolder("images").members()).stream().filter(IFile.class::isInstance).map(IFile.class::cast).filter(file -> "png".equals(file.getFileExtension())).count();
        ImagePathInRichTextAttributeMigrationTest.assertEquals((String)"Bad number of images in the images foldes", (long)3L, (long)nbImageFiles);
    }

    private void checkProjectRelativePathMigration(OperationalActivity oa) {
        Pattern pattern = Pattern.compile(this.HTML_IMAGE_PATH_PATTERN_RELATIVE);
        Matcher matcher = pattern.matcher(oa.getDescription());
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)("The project relative path migration failed. The regex" + this.HTML_IMAGE_PATH_PATTERN_RELATIVE + " should have been found. The image path should be migrated from a project relative path to a workspace relative path."), (boolean)matcher.find());
    }

    private void checkLogs() {
        this.synchronizationWithUIThread();
        List warnings = this.statuses.stream().filter(s -> s.getSeverity() == 2).collect(Collectors.toList());
        ImagePathInRichTextAttributeMigrationTest.assertEquals((String)"Bad number of warning logs", (int)2, (int)warnings.size());
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)"There should be a log that warns that an absolute path could not be migrated", (boolean)((IStatus)warnings.get(0)).getMessage().contains(this.HTML_IMAGE_INVALID_ABSOLUTE_PATH));
        ImagePathInRichTextAttributeMigrationTest.assertTrue((String)"There should be a log that warns that an relative path has been migrated but the image is not found", (boolean)((IStatus)warnings.get(1)).getMessage().contains(this.HTML_IMAGE_INVALID_RELATIVE_PATH));
    }

    private void synchronizationWithUIThread() {
        while (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) {
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
        }
    }
}

