/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class RepresentationDescriptionNonRegressionTest
extends BasicTestCase {
    protected static String MODEL_NAME = "representationDescription-1_4_x";
    protected IProject modelProject;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.modelProject = IResourceHelpers.getEclipseProjectInWorkspace((String)MODEL_NAME);
    }

    public void test() throws Exception {
        if (this.modelProject.exists()) {
            MigrationHelper.migrateProject(this.modelProject);
            Session session = this.getSessionForTestModel(MODEL_NAME);
            Predicate<DRepresentationDescriptor> isDescriptorNotMigrated = descriptor -> descriptor.getDocumentation() == null || descriptor.getDocumentation().isEmpty() || !descriptor.getDocumentation().contains(descriptor.getName());
            List notMigratedDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session).stream().filter(isDescriptorNotMigrated).collect(Collectors.toList());
            if (!notMigratedDescriptors.isEmpty()) {
                String errorMsg = notMigratedDescriptors.stream().map(DRepresentationDescriptor::getName).collect(Collectors.joining("\n"));
                RepresentationDescriptionNonRegressionTest.assertTrue((String)errorMsg, (boolean)notMigratedDescriptors.isEmpty());
            }
        }
    }
}

