/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;

public class SysmodelFilterMigration
extends BasicTestCase {
    private static final String FRAGMENT_SEPARATOR = "\\@";
    private static final String FILTER_SEPARATOR = "\\'";
    private static final String FRAGMENT_FILTER_KEY = "filters";
    private static final String PLUGIN_TYPE = "plugin";
    private static final String VALID_PLUGIN = "org.polarsys.capella.core.sirius.analysis";
    private static final String DESCRIPTION_TYPE = "description";
    private static final String PROJECT_NAME = "filter.sysmodel";
    private IProject project;
    private Map<DiagramDescription, Set<String>> validFilterNames = new HashMap<DiagramDescription, Set<String>>();

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = IResourceHelpers.getEclipseProjectInWorkspace((String)PROJECT_NAME);
    }

    public void test() throws Exception {
        if (this.project.exists()) {
            Session session = this.getSessionForTestModel(PROJECT_NAME);
            Map<String, Integer> expectedFilterNumbers = this.computeExpectedFilterNumber(session);
            session.close((IProgressMonitor)new NullProgressMonitor());
            MigrationHelper.migrateProject(this.project);
            session = this.getSessionForTestModel(PROJECT_NAME);
            List diagrams = DialectManager.INSTANCE.getAllRepresentations(session).stream().filter(DSemanticDiagram.class::isInstance).map(DSemanticDiagram.class::cast).collect(Collectors.toList());
            boolean success = true;
            for (DSemanticDiagram diagram : diagrams) {
                Integer expectedFilterNumber = expectedFilterNumbers.get(diagram.getUid());
                int currentFilterNumber = diagram.getActivatedFilters().size();
                if (expectedFilterNumber != currentFilterNumber) {
                    success = false;
                    int lostNumberOfFilters = expectedFilterNumber - currentFilterNumber;
                    System.err.println(String.valueOf(lostNumberOfFilters) + " lost filters for " + EObjectExt.getText((EObject)diagram));
                }
                for (FilterDescription filterDescription : diagram.getActivatedFilters()) {
                    InternalEObject internalObjectFilter;
                    URI filterURI;
                    String filterName = filterDescription.getName();
                    if (!filterDescription.eIsProxy() || !this.shouldAnalyseFilter(filterURI = (internalObjectFilter = (InternalEObject)filterDescription).eProxyURI()) || this.isValidFilterName(diagram.getDescription(), filterName)) continue;
                    String invalidFilterName = this.extractFilterName(filterURI);
                    System.err.println("Invalid filter " + invalidFilterName + " for " + EObjectExt.getText((EObject)diagram));
                    success = false;
                }
            }
            SysmodelFilterMigration.assertTrue((boolean)success);
        }
    }

    protected Map<String, Integer> computeExpectedFilterNumber(Session session) {
        return DialectManager.INSTANCE.getAllRepresentations(session).stream().filter(DSemanticDiagram.class::isInstance).map(DSemanticDiagram.class::cast).collect(Collectors.toMap(org.eclipse.sirius.viewpoint.IdentifiedElement::getUid, diagram -> diagram.getActivatedFilters().size()));
    }

    protected boolean isValidFilterName(DiagramDescription diagramDescription, String filterName) {
        Set validDiagramFilterNames = this.validFilterNames.computeIfAbsent(diagramDescription, desc -> desc.getFilters().stream().map(IdentifiedElement::getName).collect(Collectors.toSet()));
        return validDiagramFilterNames.contains(filterName);
    }

    protected String extractFilterName(URI filterURI) {
        String filterFragment;
        String fragment = filterURI.fragment();
        String[] tokens = fragment.split(FRAGMENT_SEPARATOR);
        if (tokens.length > 0 && (filterFragment = tokens[tokens.length - 1]).startsWith(FRAGMENT_FILTER_KEY) && (tokens = filterFragment.split(FILTER_SEPARATOR)).length == 3) {
            return tokens[1];
        }
        return null;
    }

    private boolean shouldAnalyseFilter(URI filterURI) {
        String[] filterSegments = filterURI.segments();
        return filterSegments.length == 4 && PLUGIN_TYPE.equals(filterSegments[0]) && VALID_PLUGIN.equals(filterSegments[1]) && DESCRIPTION_TYPE.equals(filterSegments[2]);
    }
}

