/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.CompareLayoutManager;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.migration.ju.helpers.MigrationHelper;
import org.polarsys.capella.test.migration.ju.model.Sysmodel;

public class SysmodelMigrationLayout
extends Sysmodel {
    public void test() throws Exception {
        IProject project = IResourceHelpers.getEclipseProjectInWorkspace((String)this.getRequiredTestModels().get(0));
        if (project.exists()) {
            DiagramHelper.setPreferenceAutoRefresh((boolean)true);
            DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
            MigrationHelper.migrateProject(project);
            this.checkLayout();
        }
    }

    protected void checkLayout() {
        CompareLayoutManager m = new CompareLayoutManager();
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        SessionLayout persisted = m.getPersistedLayout(session);
        if (persisted == null) {
            SessionLayout current = m.getCurrentLayout(session);
            m.saveLayout(session, current);
            SysmodelMigrationLayout.assertTrue((String)NLS.bind((String)"Missing file ''{0}''", (Object)m.getLayoutUri(session)), (boolean)false);
        } else {
            SessionLayout current = m.getCurrentLayout(session);
            IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation().removeLastSegments(1);
            IPath file = path.append(m.getLayoutUri(session).lastSegment());
            URI uri = URI.createFileURI((String)file.toOSString());
            m.saveLayout(session, current, uri);
            m.analysis(current, persisted);
        }
    }
}

