/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.dnd;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class DnDEMFConsistency
extends MiscModel {
    public void test() throws Exception {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        DnDEMFConsistency.assertFalse((boolean)this.canDnD(context, "c7daf8d7-abf1-4ba8-bbc5-6acc83d55cfe", "cfc9925e-c0f5-4b59-9abf-53e6a50cfc93"));
        DnDEMFConsistency.assertTrue((boolean)this.canDnD(context, "1bc6a58f-1544-4ad0-af2c-0f693b173448", "69853e79-242a-4b12-b84e-adc088ee68a0"));
        DnDEMFConsistency.assertFalse((boolean)this.canDnD(context.getSemanticElement("bdb29a96-066a-4feb-97df-8949a15a69e0"), (EObject)OaFactory.eINSTANCE.createOperationalActivity()));
        DnDEMFConsistency.assertFalse((boolean)this.canDnD(context.getSemanticElement("bdb29a96-066a-4feb-97df-8949a15a69e0"), this.createObjectAttached()));
        DnDEMFConsistency.assertTrue((boolean)this.canDnD(context, "b8b67e89-956c-405f-88a0-1099e666a13b", "4630572f-7502-4263-a994-89ced76f21a8"));
        SkeletonHelper.createInterfacePkg((String)"4630572f-7502-4263-a994-89ced76f21a8", (String)GenericModel.INTERFACE_PKG, (SessionContext)context);
        DnDEMFConsistency.assertFalse((boolean)this.canDnD(context, "b8b67e89-956c-405f-88a0-1099e666a13b", "4630572f-7502-4263-a994-89ced76f21a8"));
        SkeletonHelper.createAssociation((String)"4fa87bdb-4d64-4382-a1ff-e5d2b8e0237f", (String)GenericModel.ASSOCIATION_1, (SessionContext)context);
        SkeletonHelper.createAssociation((String)"4fa87bdb-4d64-4382-a1ff-e5d2b8e0237f", (String)GenericModel.ASSOCIATION_2, (SessionContext)context);
        SkeletonHelper.createAssociation((String)"4fa87bdb-4d64-4382-a1ff-e5d2b8e0237f", (String)GenericModel.ASSOCIATION_3, (SessionContext)context);
        SkeletonHelper.createAssociationProperty((String)GenericModel.ASSOCIATION_1, (String)"p11", (SessionContext)context);
        SkeletonHelper.createAssociationProperty((String)GenericModel.ASSOCIATION_1, (String)"p12", (SessionContext)context);
        SkeletonHelper.createAssociationProperty((String)GenericModel.ASSOCIATION_2, (String)"p2", (SessionContext)context);
        DnDEMFConsistency.assertFalse((boolean)this.canDnD(context, "p2", GenericModel.ASSOCIATION_1));
        DnDEMFConsistency.assertTrue((boolean)this.canDnD(context, "p11", GenericModel.ASSOCIATION_2));
        DnDEMFConsistency.assertTrue((boolean)this.canDnD(context, "p11", GenericModel.ASSOCIATION_3));
    }

    protected EObject createObjectAttached() {
        final EObject[] result = new EObject[1];
        final TransactionalEditingDomain domain = ExecutionManagerRegistry.getInstance().addNewManager().getEditingDomain();
        ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                result[0] = OaFactory.eINSTANCE.createOperationalActivity();
                HoldingResourceHelper.attachToHoldingResource((EObject)result[0], (Resource)HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)domain));
            }
        });
        return result[0];
    }

    protected boolean canDnD(SessionContext context, String source, String target) {
        return this.canDnD(context.getSemanticElement(source), context.getSemanticElement(target));
    }

    protected boolean canDnD(EObject source, EObject target) {
        return GuiActions.canDnD((EObject)target, Arrays.asList(source));
    }
}

