/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class ComponentExtTestCase
extends BasicTestCase {
    public static String MODEL_NAME = "miscmodel";
    public static final String STRUCTURE = "64c920b7-afe6-4d7f-b993-986ab11b1de1";
    public static final String LOGICAL_SYSTEM = "030e91dc-441e-4107-b0ea-0b08acaccf13";
    public static final String INTERNAL_LC_1 = "5b6b9d5b-d024-4423-9271-bcb3d77469c2";
    public static final String INTERNAL_LC_2 = "a30cf2b5-48d1-407e-9967-1e20e64e8e88";
    public static final String INTERNAL_ACTOR_1 = "aa969fee-8ba1-4159-9534-7a3c673ecb6c";
    public static final String INTERNAL_ACTOR_2 = "e2928bb7-f1a7-4429-9a87-0c8e79a5363f";
    public static final String INTERNAL_ACTOR_3 = "909071a7-a84b-4f6f-8ed7-7cfb65de0ec7";
    public static final String INTERNAL_ACTOR_4 = "5836f750-af83-446d-a5c3-e5da188f8940";
    public static final String INTERNAL_LOGICAL_COMPONENT_PKG_1 = "b1123d45-f6d3-411b-a3c6-ea2965a5da7b";
    public static final String EXTERNAL_LOGICALCOMPONENTPKG_3 = "5c7a8ce8-8143-484f-a995-035c994b4ee1";
    public static final String EXTERNAL_LOGICALCOMPONENTPKG_2 = "0e081fe7-60c4-4fdc-ac9b-f2c9c420f10a";
    public static final String EXTERNAL_LOGICALCOMPONENTPKG_1 = "379f621c-9326-4a29-a257-613abc3361e6";
    public static final String EXTERNAL_LC_1 = "85825d12-d200-46f7-be30-6d29351293ee";
    public static final String EXTERNAL_LC_2 = "04e39155-3750-4817-8a50-658779096d3f";
    public static final String EXTERNAL_ACTOR_1 = "8ae1f1b4-0b84-457b-bc67-2aff89b87589";
    public static final String EXTERNAL_ACTOR_2 = "b406eba9-368e-4583-bfd4-64e00bf65288";
    public static final String EXTERNAL_ACTOR_3 = "51dc6471-52d0-416d-ad70-908e5f7fb087";
    public static final String EXTERNAL_ACTOR_4 = "6040d11f-b504-449c-9f09-3cdf81008713";
    public static final String EXTERNAL_ACTOR_5 = "d91ea798-c1be-40b4-b107-ea7c368e6a4e";
    public static final String EXTERNAL_ACTOR_6 = "152d75ac-4cc4-4255-ba3d-2de5facf2f69";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        ComponentExtTestCase.assertTrue((String)"Structure / Actor : is an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(EXTERNAL_ACTOR_1, (IScope)scope))));
        ComponentExtTestCase.assertTrue((String)"Structure / Actor / Actor : is an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(EXTERNAL_ACTOR_2, (IScope)scope))));
        ComponentExtTestCase.assertTrue((String)"Structure / Component Package / Actor : is an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(EXTERNAL_ACTOR_4, (IScope)scope))));
        ComponentExtTestCase.assertTrue((String)"Structure / Component Package / Actor / Actor : is an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(EXTERNAL_ACTOR_5, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Structure / Logical System / Actor : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(INTERNAL_ACTOR_2, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Structure / Logical System / Actor / Actor : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(INTERNAL_ACTOR_3, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Structure / Logical System / Component / Actor : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(INTERNAL_ACTOR_1, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Structure / Logical System / Component Package / Actor : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(INTERNAL_ACTOR_4, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Component : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(EXTERNAL_LC_2, (IScope)scope))));
        ComponentExtTestCase.assertFalse((String)"Component : is not an external actor", (boolean)ComponentExt.isExternalActor((Component)((Component)IdManager.getInstance().getEObject(INTERNAL_LC_2, (IScope)scope))));
        List subActors = ComponentExt.getAllActors((Component)((Component)IdManager.getInstance().getEObject(LOGICAL_SYSTEM, (IScope)scope))).stream().map(e -> e.getId()).collect(Collectors.toList());
        ComponentExtTestCase.assertTrue((boolean)subActors.containsAll(Arrays.asList(INTERNAL_ACTOR_1, INTERNAL_ACTOR_2, INTERNAL_ACTOR_3, INTERNAL_ACTOR_4)));
        ComponentExtTestCase.assertEquals((int)subActors.size(), (int)4);
        ComponentExtTestCase.assertTrue((ComponentExt.getSubParts(null).size() == 0 ? 1 : 0) != 0);
        ComponentExtTestCase.assertTrue((ComponentExt.getSubParts(null, (boolean)true).size() == 0 ? 1 : 0) != 0);
        ComponentExtTestCase.assertTrue((ComponentExt.getSubParts(null, (boolean)false).size() == 0 ? 1 : 0) != 0);
    }
}

