/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.helpers;

import java.util.Arrays;
import java.util.List;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class PartExtTestCase
extends BasicTestCase {
    public static final String ACTOR_BEHAVIOR_2 = "3eea84a2-f2a3-4efc-93f2-cf44dfc2020b";
    public static final String DEPLOYED_PC_NODE_1 = "579dcdaa-98a1-4c79-a2d9-64adc202319e";
    public static final String DEPLOYED_ACTOR_NODE_1 = "f0eb97d1-919c-453a-909c-f3db749bff04";
    public static String MODEL_NAME = "miscmodel";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(MODEL_NAME);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        PartExtTestCase.assertFalse((String)"In mono part mode, deployed part is not deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(DEPLOYED_PC_NODE_1, (IScope)scope)).getRepresentingParts().get(0))));
        PartExtTestCase.assertFalse((String)"In mono part mode, deployed part is not deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(DEPLOYED_ACTOR_NODE_1, (IScope)scope)).getRepresentingParts().get(0))));
        PartExtTestCase.assertTrue((String)"In mono part mode, not deployed part is deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope)).getRepresentingParts().get(0))));
        ScopedCapellaPreferencesStore.getInstance((String)"").setValue("deployment.allowed", true);
        PartExtTestCase.assertTrue((String)"In multi part mode, deployed part is deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(DEPLOYED_PC_NODE_1, (IScope)scope)).getRepresentingParts().get(0))));
        PartExtTestCase.assertTrue((String)"In multi part mode, deployed part is deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(DEPLOYED_ACTOR_NODE_1, (IScope)scope)).getRepresentingParts().get(0))));
        PartExtTestCase.assertTrue((String)"In multi part mode, not deployed part is deployable", (boolean)PartExt.isDeployable((Part)((Part)((Component)IdManager.getInstance().getEObject(ACTOR_BEHAVIOR_2, (IScope)scope)).getRepresentingParts().get(0))));
        ScopedCapellaPreferencesStore.getInstance((String)"").setValue("deployment.allowed", false);
    }
}

