/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.propertyviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.flexibility.wizards.ui.tabbed.PropertiesTabDescriptor;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.sharedmodel.GenericPkg;
import org.polarsys.capella.core.data.sharedmodel.SharedmodelFactory;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class PropertyViewsTest
extends BasicTestCase {
    protected List<EClass> excludedClasses = Arrays.asList(InteractionPackage.Literals.SEQUENCE_MESSAGE_VALUATION, RePackage.Literals.GROUPING_ELEMENT_PKG, LibrariesPackage.Literals.MODEL_INFORMATION, LibrariesPackage.Literals.LIBRARY_REFERENCE, LibrariesPackage.Literals.MODEL_VERSION);

    public void test() throws Exception {
        Collection<EClass> concreteClasses = this.getConcreteClasses(this.getAllCapellaPackages());
        concreteClasses.removeAll(this.excludedClasses);
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        Collection<EObject> objects = this.createEObjectFromClasses(manager, concreteClasses);
        System.out.println("Concrete classes: " + concreteClasses.size());
        this.checkCustomPropertyViews(manager.getEditingDomain(), objects);
    }

    public void checkCustomPropertyViews(TransactionalEditingDomain domain, Collection<EObject> objects) {
        CapellaCommonNavigator part = (CapellaCommonNavigator)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry((ITabbedPropertySheetPageContributor)part);
        ArrayList<String> errors = new ArrayList<String>();
        for (final EObject object : objects) {
            ITabDescriptor[] result = registry.getTabDescriptors((IWorkbenchPart)part, (ISelection)new StructuredSelection((Object)object));
            Predicate<ITabDescriptor> descriptors = new Predicate<ITabDescriptor>(){

                @Override
                public boolean test(ITabDescriptor t) {
                    return "BaseCapella".equals(t.getId()) || PropertyViewsTest.this.isLibraryOrRec(object) && t instanceof PropertiesTabDescriptor;
                }
            };
            Optional<ITabDescriptor> capella = Arrays.asList(result).stream().filter(descriptors).findFirst();
            if (!capella.isPresent()) {
                errors.add(NLS.bind((String)"No Property Tab 'Capella' for {0}", (Object)object.eClass().getInstanceTypeName()));
                continue;
            }
            ITabDescriptor tab = capella.get();
            if (tab.getSectionDescriptors().isEmpty()) {
                errors.add(NLS.bind((String)"Property Tab 'Capella' is empty for {0}", (Object)object.eClass().getInstanceTypeName()));
            }
            for (Object section : tab.getSectionDescriptors()) {
                ISectionDescriptor descriptor = (ISectionDescriptor)section;
                if (descriptor.getSectionClass() != null) continue;
                errors.add(NLS.bind((String)"Property Capella Section no longer exist {0}", (Object)descriptor.getSectionClass()));
            }
        }
        PropertyViewsTest.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
    }

    private Collection<EPackage> getAllCapellaPackages() {
        return EPackage.Registry.INSTANCE.keySet().stream().filter(x -> x.contains("capella") && !x.contains("org.polarsys.capella.layout")).map(x -> EPackage.Registry.INSTANCE.getEPackage(x)).collect(Collectors.toList());
    }

    private Collection<EClass> getConcreteClasses(Collection<EPackage> packages) {
        ArrayList<EClass> concreteClasses = new ArrayList<EClass>(0);
        for (EPackage pkg : packages) {
            for (EClassifier clazz : pkg.getEClassifiers()) {
                if (!(clazz instanceof EClass) || ((EClass)clazz).isAbstract()) continue;
                concreteClasses.add((EClass)clazz);
            }
        }
        return concreteClasses;
    }

    private Collection<EObject> createEObjectFromClasses(final ExecutionManager manager, final Collection<EClass> classes) {
        final ArrayList<EObject> result = new ArrayList<EObject>();
        manager.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                GenericPkg object = SharedmodelFactory.eINSTANCE.createGenericPkg();
                Resource resource = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)manager.getEditingDomain());
                HoldingResourceHelper.attachToHoldingResource((EObject)object, (Resource)resource);
                for (EClass eclass : classes) {
                    EObject s = eclass.getEPackage().getEFactoryInstance().create(eclass);
                    if (s instanceof ModelElement) {
                        object.getOwnedMigratedElements().add((Object)((ModelElement)s));
                    } else if (s instanceof ElementExtension) {
                        object.getOwnedExtensions().add((Object)((ElementExtension)s));
                    } else if (!PropertyViewsTest.this.isLibraryOrRec(s)) {
                        PropertyViewsTest.assertFalse((String)("Can't store an element in model. This might be unexpected for new elements. " + eclass.getInstanceTypeName()), (boolean)true);
                    }
                    result.add(s);
                }
            }
        });
        return result;
    }

    private boolean isLibraryOrRec(EObject object) {
        return object.eClass().getEPackage() == LibrariesPackage.eINSTANCE || object.eClass().getEPackage() == RePackage.eINSTANCE;
    }
}

