/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.rename;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;

public class RenameAirdWithSpaceInProjectNameTestCase
extends BasicTestCase {
    private static String projectName = "renameTest 1  2";
    private static String fileRenamed = "renameTest12";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectName);
    }

    public void test() throws Exception {
        String oldFileName = String.valueOf(projectName) + "." + "aird";
        IFile airdFile = this.getAirdFileForLoadedModel(projectName);
        if (airdFile.exists()) {
            String newAirdFileName = String.valueOf(fileRenamed) + "." + "aird";
            String newAmfFileName = String.valueOf(fileRenamed) + "." + "afm";
            GuiActions.renameModelFile((IFile)airdFile, (String)newAirdFileName);
            IFile afmFile = IResourceHelpers.getEclipseProjectInWorkspace((String)projectName).getFile(newAmfFileName);
            RenameAirdWithSpaceInProjectNameTestCase.assertTrue((String)"The file doesn't exist", (boolean)afmFile.exists());
            IFile fileRenamed = IResourceHelpers.getEclipseProjectInWorkspace((String)projectName).getFile(newAirdFileName);
            RenameAirdWithSpaceInProjectNameTestCase.assertTrue((String)"The file doesn't exist", (boolean)fileRenamed.exists());
            Session session = SessionManager.INSTANCE.getSession(EcoreUtil2.getURI((IFile)fileRenamed), (IProgressMonitor)new NullProgressMonitor());
            RenameAirdWithSpaceInProjectNameTestCase.assertTrue((String)"Session is not loaded with renamed resource", (session != null ? 1 : 0) != 0);
            session.close((IProgressMonitor)new NullProgressMonitor());
            GuiActions.renameModelFile((IFile)fileRenamed, (String)oldFileName);
        }
    }
}

