/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcases.intermodelInconsistencies;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.test.model.ju.CheckInterModelInconsistencyDetectionTestCase;

public class CheckDependencyViolationTwoLevel
extends CheckInterModelInconsistencyDetectionTestCase {
    public List<String> getRequiredTestModels() {
        return Arrays.asList("intermodelInconsistencies/P", "intermodelInconsistencies/L1", "intermodelInconsistencies/L2");
    }

    public void test() throws Exception {
        CapellaModel modelA = this.getTestModel("intermodelInconsistencies/P");
        Project projectA = modelA.getProject(modelA.getEditingDomain());
        SystemEngineering systemA = this.getSystemEngineering(projectA);
        LogicalArchitecture logArchA = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemA);
        final DataPkg dataPckA = logArchA.getOwnedDataPkg();
        final Class class1 = this.getClassNamed("Class 1", dataPckA);
        final Class class2 = this.getClassNamed("Class 2", dataPckA);
        CapellaModel modelB = this.getTestModel("intermodelInconsistencies/L2");
        Project projectB = modelB.getProject(modelA.getEditingDomain());
        SystemEngineering systemB = this.getSystemEngineering(projectB);
        LogicalArchitecture logArchB = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemB);
        final DataPkg dataPckB = logArchB.getOwnedDataPkg();
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckB.getOwnedClasses().add((Object)class2);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationTwoLevel.assertFalse((boolean)command.isRolledBack());
        command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckA.getOwnedClasses().add((Object)class2);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationTwoLevel.assertFalse((boolean)command.isRolledBack());
        command = new AbstractReadWriteCommand(){

            public void run() {
                dataPckB.getOwnedClasses().add((Object)class1);
            }
        };
        TransactionHelper.getExecutionManager((EObject)projectA).execute((ICommand)command);
        CheckDependencyViolationTwoLevel.assertTrue((boolean)command.isRolledBack());
    }
}

