/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.identifier;

import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.ui.services.IElementIdentifierService;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.odesign.identifier.IdentifierHelper;

public class DuplicateToolsAndFiltersTest
extends BasicTestCase {
    public void test() {
        HashSet ids = new HashSet();
        HashSet duplicatedIds = new HashSet();
        IElementIdentifierService elementIdentifier = (IElementIdentifierService)PlatformUI.getWorkbench().getService(IElementIdentifierService.class);
        for (Viewpoint viewpoint : ViewpointSelection.getViewpoints((String)"capella")) {
            EList descriptions = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription description : descriptions) {
                if (!(description instanceof DiagramDescription)) continue;
                DiagramDescription diagramDescription = (DiagramDescription)description;
                IdentifierHelper.getTools(diagramDescription).forEach(element -> {
                    boolean isIdDuplicated;
                    String toolIdentifier = elementIdentifier.getIdentifier(diagramDescription, element);
                    boolean bl = isIdDuplicated = !ids.add(toolIdentifier);
                    if (isIdDuplicated) {
                        duplicatedIds.add(toolIdentifier);
                    }
                });
            }
        }
        if (!duplicatedIds.isEmpty()) {
            DuplicateToolsAndFiltersTest.assertTrue((String)("There is some duplicated tools: " + duplicatedIds.stream().collect(Collectors.joining("\n"))), (boolean)duplicatedIds.isEmpty());
        }
    }
}

