/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.identifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ToolGroup;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;

public class IdentifierHelper {
    private static final String IGNORED_MODEL_EXTENSION_FILTER = "ModelExtensionFilter";
    private static final Predicate<IdentifiedElement> toolFilter = tool -> tool instanceof ContainerCreationDescription || tool instanceof NodeCreationDescription || tool instanceof ToolDescription || tool instanceof PopupMenu || tool instanceof OperationAction || tool instanceof EdgeCreationDescription;
    private static final Predicate<IdentifiedElement> filterFilter = tool -> tool instanceof CompositeFilterDescription && !tool.getName().equals(IGNORED_MODEL_EXTENSION_FILTER);

    public static Stream<IdentifiedElement> getTools(DiagramDescription description) {
        return Stream.concat(IdentifierHelper.getAllTools(description).stream().flatMap(x -> {
            if (x instanceof PopupMenu) {
                return Stream.concat(Stream.of(x), ((PopupMenu)x).getMenuItemDescription().stream());
            }
            return Stream.of(x);
        }).distinct(), description.getFilters().stream()).filter(toolFilter.or(filterFilter));
    }

    private static Set<AbstractToolDescription> getAllTools(DiagramDescription self) {
        LinkedHashSet<AbstractToolDescription> result = new LinkedHashSet<AbstractToolDescription>();
        if (self.getToolSection() != null) {
            for (AbstractToolDescription eObj : IdentifierHelper.getTools((EObject)self.getToolSection())) {
                result.add(eObj);
            }
        }
        for (Layer layer : LayerModelHelper.getAllLayers((DiagramDescription)self)) {
            if (layer == null) continue;
            result.addAll((Collection<AbstractToolDescription>)IdentifierHelper.getAllTools(layer));
        }
        return result;
    }

    private static EList<AbstractToolDescription> getAllTools(Layer layer) {
        LinkedHashSet<AbstractToolDescription> result = new LinkedHashSet<AbstractToolDescription>();
        TreeIterator it = layer.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            result.addAll(IdentifierHelper.getTools(eObj));
        }
        return new EcoreEList.UnmodifiableEList((InternalEObject)layer.eContainer(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getLayer_AllTools(), result.size(), result.toArray());
    }

    private static Collection<AbstractToolDescription> getTools(EObject eObj) {
        ArrayList<AbstractToolDescription> tools = new ArrayList<AbstractToolDescription>();
        if (eObj instanceof AbstractToolDescription) {
            tools.add((AbstractToolDescription)eObj);
        } else if (eObj instanceof ToolGroup) {
            tools.addAll((Collection<AbstractToolDescription>)((ToolGroup)eObj).getTools());
        } else if (eObj instanceof ToolSection) {
            for (ToolEntry toolEntry : ((ToolSection)eObj).getOwnedTools()) {
                tools.addAll(IdentifierHelper.getTools((EObject)toolEntry));
            }
        }
        return tools;
    }
}

