/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.identifier;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.polarsys.capella.core.platform.sirius.ui.services.IElementIdentifierService;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.odesign.identifier.IdentifierHelper;

public class ToolActivityCoverageTest
extends BasicTestCase {
    public void test() {
        ArrayList<String> errors = new ArrayList<String>();
        List<String> toolsToCheck = this.getToolsListFromFile("src/org/polarsys/capella/test/odesign/identifier/toolsToCheck.txt");
        for (String toolIdentifier : toolsToCheck) {
            IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            IIdentifier id = activityManager.getIdentifier(toolIdentifier);
            if (!id.getActivityIds().isEmpty()) continue;
            errors.add(NLS.bind((String)"Tool {0} not covered by an activity.", (Object)toolIdentifier));
        }
        ToolActivityCoverageTest.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
    }

    private List<String> getToolsListFromViewpoint() {
        ArrayList<String> list = new ArrayList<String>();
        IElementIdentifierService elementIdentifier = (IElementIdentifierService)PlatformUI.getWorkbench().getService(IElementIdentifierService.class);
        for (Viewpoint viewpoint : ViewpointSelection.getViewpoints((String)"capella")) {
            EList descriptions = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription description : descriptions) {
                if (!(description instanceof DiagramDescription)) continue;
                DiagramDescription diagramDescription = (DiagramDescription)description;
                IdentifierHelper.getTools(diagramDescription).forEach(element -> {
                    String toolIdentifier = elementIdentifier.getIdentifier(diagramDescription, element);
                    list.add(toolIdentifier);
                });
            }
        }
        return list;
    }

    private List<String> getToolsListFromFile(String path) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(path)));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    list.add(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("importToolsListFromFile failed!");
        }
        return list;
    }
}

