/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.ju.titleblock;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.odesign.helper.OdesignTestHelper;
import org.polarsys.capella.test.odesign.ju.titleblock.CheckTitleBlockTest;

public class CheckTitleBlockMappingTest
extends CheckTitleBlockTest {
    public void test() throws Exception {
        AbstractNodeMapping titleBlockContainerMapping;
        DiagramDescription classDiagramDescription;
        Viewpoint commonVP = OdesignTestHelper.getViewpointByName("Common");
        if (commonVP == null) {
            CheckTitleBlockMappingTest.fail((String)"Common viewpoint not found");
        }
        if ((classDiagramDescription = OdesignTestHelper.getDiagramDescriptionByName(commonVP, "Class Diagram Blank")) == null) {
            CheckTitleBlockMappingTest.fail((String)"CBD diagram description not found");
        }
        if ((titleBlockContainerMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(classDiagramDescription, "DT_TitleBlockContainer")) == null) {
            CheckTitleBlockMappingTest.fail((String)"Title block container mapping not found");
        }
        this.assertAllDiagramContainMapping((DiagramElementMapping)titleBlockContainerMapping);
        EdgeMapping titleBlockEdgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(classDiagramDescription, "DT_TitleBlockEdge");
        if (titleBlockEdgeMapping == null) {
            CheckTitleBlockMappingTest.fail((String)"Title block edge mapping not found");
        }
        this.assertAllDiagramContainMapping((DiagramElementMapping)titleBlockEdgeMapping);
    }

    private void assertAllDiagramContainMapping(DiagramElementMapping mapping) {
        List<DiagramDescription> diagramDescriptionsWithoutMapping = this.getDiagramDescriptionsWithoutMapping(mapping);
        CheckTitleBlockMappingTest.assertTrue((String)("The following diagrams do not have Title block " + mapping.getName() + " mapping: " + diagramDescriptionsWithoutMapping.stream().map(m -> m.getName()).collect(Collectors.joining(", "))), (boolean)diagramDescriptionsWithoutMapping.isEmpty());
    }

    private List<DiagramDescription> getDiagramDescriptionsWithoutMapping(DiagramElementMapping mapping) {
        return ViewpointRegistry.getInstance().getViewpoints().stream().flatMap(vp -> vp.getOwnedRepresentations().stream()).filter(DiagramDescription.class::isInstance).map(DiagramDescription.class::cast).filter(des -> !this.isDiagramDescriptionIgnored((DiagramDescription)des)).filter(des -> !OdesignTestHelper.hasMapping(des, mapping)).collect(Collectors.toList());
    }
}

