/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.ju.titleblock;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.polarsys.capella.test.odesign.helper.OdesignTestHelper;
import org.polarsys.capella.test.odesign.ju.titleblock.CheckTitleBlockTest;

public class CheckTitleBlockToolTest
extends CheckTitleBlockTest {
    public void test() throws Exception {
        this.assertAllDiagramContainTool("title.block");
        this.assertAllDiagramContainTool("title.block.column");
        this.assertAllDiagramContainTool("title.block.line");
        this.assertAllDiagramContainTool("title.blocks");
        this.assertAllDiagramContainTool("remove.title.block.column");
        this.assertAllDiagramContainTool("remove.title.block.line");
    }

    private void assertAllDiagramContainTool(String toolName) {
        List<DiagramDescription> diagramDescriptionsWithoutTool = this.getDiagramDescriptionsWithoutTool(toolName);
        CheckTitleBlockToolTest.assertTrue((String)("The following diagrams do not have Title block " + toolName + " tool: " + diagramDescriptionsWithoutTool.stream().map(m -> m.getName()).collect(Collectors.joining(", "))), (boolean)diagramDescriptionsWithoutTool.isEmpty());
    }

    private List<DiagramDescription> getDiagramDescriptionsWithoutTool(String toolName) {
        return ViewpointRegistry.getInstance().getViewpoints().stream().flatMap(vp -> vp.getOwnedRepresentations().stream()).filter(DiagramDescription.class::isInstance).map(DiagramDescription.class::cast).filter(des -> !this.isDiagramDescriptionIgnored((DiagramDescription)des)).filter(des -> !OdesignTestHelper.hasTool(des, toolName)).collect(Collectors.toList());
    }
}

