/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.typereferencename;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.table.metamodel.table.description.CreateCellTool;
import org.eclipse.sirius.table.metamodel.table.description.CreateLineTool;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ContainerModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.polarsys.capella.test.framework.api.BasicTestArtefact;
import org.polarsys.capella.test.odesign.typereferencename.CheckReferenceNameTest;
import org.polarsys.capella.test.odesign.typereferencename.CheckTypeNameTest;

public class TypeReferenceNameUtils {
    public static CheckTypeNameTest getTypeNameTest(RepresentationDescription diagram_p, AbstractToolDescription tool_p, String typeName_p) {
        CheckTypeNameTest test = new CheckTypeNameTest(typeName_p);
        return test;
    }

    public static CheckReferenceNameTest getReferenceNameTest(RepresentationDescription diagram_p, AbstractToolDescription tool_p, String refName_p) {
        CheckReferenceNameTest refNameTest = new CheckReferenceNameTest(refName_p);
        return refNameTest;
    }

    public static ModelOperation getFistOperation(AbstractToolDescription tool_p) {
        if (tool_p instanceof ToolDescription) {
            return ((ToolDescription)tool_p).getInitialOperation().getFirstModelOperations();
        }
        if (tool_p instanceof ContainerCreationDescription) {
            return ((ContainerCreationDescription)tool_p).getInitialOperation().getFirstModelOperations();
        }
        if (tool_p instanceof NodeCreationDescription) {
            return ((NodeCreationDescription)tool_p).getInitialOperation().getFirstModelOperations();
        }
        if (tool_p instanceof EdgeCreationDescription) {
            return ((EdgeCreationDescription)tool_p).getInitialOperation().getFirstModelOperations();
        }
        if (tool_p instanceof CreateLineTool) {
            return ((CreateLineTool)tool_p).getFirstModelOperation();
        }
        if (tool_p instanceof CreateCellTool) {
            return ((CreateCellTool)tool_p).getFirstModelOperation();
        }
        return null;
    }

    public static List<BasicTestArtefact> getCreateInstanceTests(RepresentationDescription diagram_p, AbstractToolDescription tool_p, ContainerModelOperation operation_p) {
        ArrayList<BasicTestArtefact> testsList = new ArrayList<BasicTestArtefact>();
        if (operation_p instanceof CreateInstance) {
            CreateInstance createInstance = (CreateInstance)operation_p;
            String typeName = createInstance.getTypeName();
            String refName = createInstance.getReferenceName();
            CheckTypeNameTest typeNameTest = TypeReferenceNameUtils.getTypeNameTest(diagram_p, tool_p, typeName);
            CheckReferenceNameTest referenceNameTest = TypeReferenceNameUtils.getReferenceNameTest(diagram_p, tool_p, refName);
            testsList.add((BasicTestArtefact)typeNameTest);
            testsList.add((BasicTestArtefact)referenceNameTest);
        }
        return testsList;
    }

    public static void findCreateInstance(RepresentationDescription diagram_p, AbstractToolDescription tool_p, ModelOperation operation_p, List<BasicTestArtefact> tests_p) {
        if (operation_p instanceof CreateInstance) {
            List<BasicTestArtefact> createInstanceTests = TypeReferenceNameUtils.getCreateInstanceTests(diagram_p, tool_p, (ContainerModelOperation)((CreateInstance)operation_p));
            tests_p.addAll(createInstanceTests);
        }
        if (operation_p instanceof ContainerModelOperation) {
            ContainerModelOperation cmo = (ContainerModelOperation)operation_p;
            EList subModelOperations = cmo.getSubModelOperations();
            for (ModelOperation next : subModelOperations) {
                if (next instanceof CreateInstance) {
                    CreateInstance createInstance = (CreateInstance)next;
                    List<BasicTestArtefact> createInstanceTests = TypeReferenceNameUtils.getCreateInstanceTests(diagram_p, tool_p, (ContainerModelOperation)createInstance);
                    tests_p.addAll(createInstanceTests);
                    continue;
                }
                TypeReferenceNameUtils.findCreateInstance(diagram_p, tool_p, next, tests_p);
            }
        }
    }

    public static void findCreateInstanceInLineMappings(RepresentationDescription diagram_p, List<LineMapping> lines_p, List<BasicTestArtefact> tests_p) {
        for (LineMapping lineMapping : lines_p) {
            EList create = lineMapping.getCreate();
            for (CreateLineTool current : create) {
                ModelOperation fistOperation = TypeReferenceNameUtils.getFistOperation((AbstractToolDescription)current);
                TypeReferenceNameUtils.findCreateInstance(diagram_p, (AbstractToolDescription)current, fistOperation, tests_p);
            }
        }
    }

    public static void findCreateInstanceInIntersectionMappings(RepresentationDescription diagram_p, List<IntersectionMapping> intersections_p, List<BasicTestArtefact> tests_p) {
        for (IntersectionMapping intersectionMapping : intersections_p) {
            CreateCellTool create = intersectionMapping.getCreate();
            ModelOperation fistOperation = TypeReferenceNameUtils.getFistOperation((AbstractToolDescription)create);
            TypeReferenceNameUtils.findCreateInstance(diagram_p, (AbstractToolDescription)create, fistOperation, tests_p);
        }
    }
}

