/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.recrpl.ju.testcases.compliance;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.test.recrpl.ju.model.Compliance;

public class BlackboxComplianceTest3
extends Compliance {
    private PhysicalArchitecture pa;
    private PhysicalComponent rootPC;
    private CatalogElement rec;
    private PhysicalComponent pcRec1;
    private PhysicalComponent pcRec2;
    private CatalogElement rpl;
    private PhysicalComponent pcRpl1;
    private PhysicalComponent pcRpl2;
    private PhysicalFunction rootPf;
    private PhysicalFunction pfRec;
    private PhysicalFunction pfRpl;

    @Override
    public void test() throws Exception {
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((Project)this.getProject());
        this.pa = SystemEngineeringExt.getPhysicalArchitecture((SystemEngineering)se);
        this.rootPC = (PhysicalComponent)this.pa.getSystem();
        this.expectNoRollback(() -> {
            this.pcRec1 = PaFactory.eINSTANCE.createPhysicalComponent("PC1");
            this.pcRec1.setDescription("pc description");
            this.rootPC.getOwnedPhysicalComponents().add((Object)this.pcRec1);
            this.pcRec2 = PaFactory.eINSTANCE.createPhysicalComponent("PC2");
            this.pcRec2.setDescription("pc 2 description");
            this.rootPC.getOwnedPhysicalComponents().add((Object)this.pcRec2);
            this.rootPf = (PhysicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)this.pa);
            this.pfRec = PaFactory.eINSTANCE.createPhysicalFunction("pf1");
            this.rootPf.getOwnedFunctions().add((Object)this.pfRec);
            FaServices.getFaServices().allocateToComponent((AbstractFunction)this.pfRec, (Component)this.pcRec1);
        });
        this.rec = this.createREC(Arrays.asList(this.pcRec1, this.pcRec2, (CapellaElement)this.pcRec1.getOwnedFunctionalAllocation().get(0), this.pfRec));
        this.rpl = this.createReplica(Collections.singleton(this.rootPC), this.rec, "SUFFIX");
        for (CatalogElementLink l : this.rpl.getOwnedLinks()) {
            if (l.getOrigin().getTarget() == this.pcRec1) {
                this.pcRpl1 = (PhysicalComponent)l.getTarget();
            }
            if (l.getOrigin().getTarget() == this.pcRec2) {
                this.pcRpl2 = (PhysicalComponent)l.getTarget();
            }
            if (l.getOrigin().getTarget() != this.pfRec) continue;
            this.pfRpl = (PhysicalFunction)l.getTarget();
        }
        this.expectNoRollback(() -> this.rpl.setReadOnly(true));
        this.expectRollback(() -> {
            this.pcRpl2.getOwnedFunctionalAllocation().addAll((Collection)this.pcRpl1.getOwnedFunctionalAllocation());
            for (ComponentFunctionalAllocation alloc : this.pcRpl2.getOwnedFunctionalAllocation()) {
                alloc.setSourceElement((TraceableElement)this.pcRpl2);
            }
        });
        this.expectNoRollback(() -> {
            this.pcRec2.getOwnedFunctionalAllocation().addAll((Collection)this.pcRec1.getOwnedFunctionalAllocation());
            for (ComponentFunctionalAllocation alloc : this.pcRec2.getOwnedFunctionalAllocation()) {
                alloc.setSourceElement((TraceableElement)this.pcRec2);
            }
        });
        this.updateReplica(Collections.singleton(this.pcRpl1), this.rpl);
        BlackboxComplianceTest3.assertTrue((boolean)this.pcRpl1.getAllocatedFunctions().isEmpty());
        BlackboxComplianceTest3.assertTrue((boolean)this.pcRpl1.getOwnedFunctionalAllocation().isEmpty());
        BlackboxComplianceTest3.assertTrue((this.pcRpl2.getOwnedFunctionalAllocation().size() == 1 ? 1 : 0) != 0);
        BlackboxComplianceTest3.assertTrue((this.pcRpl2.getAllocatedFunctions().size() == 1 && this.pcRpl2.getAllocatedFunctions().contains((Object)this.pfRpl) ? 1 : 0) != 0);
    }
}

