/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.run;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;
import org.eclipse.jdt.internal.junit.model.RemoteTestRunnerClient;
import org.polarsys.capella.test.run.TestRunListener;

public class ConsoleTestRunnerApplication
implements IApplication {
    private static TestRunListener testListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(int port, String title) throws InterruptedException {
        testListener = new TestRunListener(this, title);
        RemoteTestRunnerClient client = new RemoteTestRunnerClient();
        client.startListening(new ITestRunListener2[]{testListener}, port);
        System.err.println("Listening on port " + port + " for test suite " + title + " results ...");
        System.out.println("Listening on port " + port + " for test suite " + title + " results ...");
        ConsoleTestRunnerApplication consoleTestRunnerApplication = this;
        synchronized (consoleTestRunnerApplication) {
            this.wait();
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = Platform.getCommandLineArgs();
        System.out.println("");
        System.out.println("getCommandLineArgs");
        System.out.println(Arrays.asList(args).stream().collect(Collectors.joining("\n")));
        System.out.println("");
        System.out.println("getArguments");
        System.out.println(Arrays.asList(context.getArguments()).stream().map(x -> x.toString()).collect(Collectors.joining("\n")));
        String port = null;
        String title = "TestSuite";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port") && i < args.length - 1) {
                port = args[i + 1];
            }
            if (args[i].equals("-title") && i < args.length - 1) {
                title = args[i + 1];
            }
            ++i;
        }
        if (port == null) {
            System.out.println("usage: -port port -title title");
            System.exit(0);
        }
        try {
            this.run(Integer.parseInt(port), title);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }
}

