/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.run;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunListenerAdapter;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.polarsys.capella.test.run.TestRunListener;

public class JDTTestRunnerApplication
implements IApplication {
    private static TestRunListener testListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(int port, final String title) throws InterruptedException {
        Launch launch = new Launch(null, "run", null);
        final TestRunSession session = new TestRunSession((ILaunch)launch, (IJavaProject)new JavaProject(){

            public String getElementName() {
                return title;
            }
        }, port);
        session.addTestSessionListener((ITestSessionListener)new TestRunListenerAdapter(session));
        session.addTestSessionListener(new ITestSessionListener(){

            public void testStarted(TestCaseElement testCaseElement) {
            }

            public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
            }

            public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
            }

            public void testEnded(TestCaseElement testCaseElement) {
            }

            public void testAdded(TestElement testElement) {
            }

            public void sessionTerminated() {
                System.out.println(session);
            }

            public void sessionStopped(long elapsedTime) {
                JDTTestRunnerApplication.this.notifyAll();
            }

            public void sessionStarted() {
                System.out.println(session);
            }

            public void sessionEnded(long elapsedTime) {
                System.out.println(session);
                JDTTestRunnerApplication.this.notifyAll();
            }

            public void runningBegins() {
            }

            public boolean acceptsSwapToDisk() {
                return false;
            }
        });
        JDTTestRunnerApplication jDTTestRunnerApplication = this;
        synchronized (jDTTestRunnerApplication) {
            this.wait();
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = Platform.getCommandLineArgs();
        System.out.println("");
        System.out.println("getCommandLineArgs");
        System.out.println(Arrays.asList(args).stream().collect(Collectors.joining("\n")));
        System.out.println("");
        System.out.println("getArguments");
        System.out.println(Arrays.asList(context.getArguments()).stream().map(x -> x.toString()).collect(Collectors.joining("\n")));
        String port = null;
        String title = "TestSuite";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-port") && i < args.length - 1) {
                port = args[i + 1];
            }
            if (args[i].equals("-title") && i < args.length - 1) {
                title = args[i + 1];
            }
            ++i;
        }
        if (port == null) {
            System.out.println("usage: -port port -title title");
            System.exit(0);
        }
        try {
            this.run(Integer.parseInt(port), title);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }
}

