/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.MenuItemDescription;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.ToolWrapperFactory;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.table.ju.utils.TableToolHelper;

public abstract class AbstractTableToolStep
extends AbstractTestStep {
    protected String toolName;
    protected String toolLabel;
    protected AbstractToolWrapper _toolWrapper;
    protected SessionContext sessionContext;
    protected DTable table;
    protected EClass toolEClass;

    public AbstractTableToolStep(SessionContext executionContext, EClass toolEClass, DTable t) {
        this(executionContext, null, toolEClass, t);
    }

    public AbstractTableToolStep(SessionContext executionContext, String toolName, EClass toolEClass, DTable t) {
        super(executionContext);
        this.sessionContext = executionContext;
        this.table = t;
        this.toolName = toolName;
        this.toolEClass = toolEClass;
    }

    protected abstract void initToolArguments();

    private void initializeToolAndCheckArguments() {
        Session currentSession = this.getExecutionContext().getSession();
        TableToolHelper helper = new TableToolHelper(currentSession, this.table);
        AbstractToolDescription tool = this.toolName == null ? helper.getTool(this.toolEClass) : helper.getTool(this.toolEClass, this.toolName);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolDoesNotExist, (Object)this.toolEClass), (Object)tool);
        this._toolWrapper = ToolWrapperFactory.INSTANCE.createToolCommandWrapper(tool);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolWrapperNotAvailable, (Object)this.toolName), (Object)this._toolWrapper);
        this.initToolArguments();
        IStatus isArgumentOk = this._toolWrapper.checkArguments();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentErr, (Object)isArgumentOk.toString()), (boolean)isArgumentOk.isOK());
    }

    protected void preRunTest() {
        this.initializeToolAndCheckArguments();
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentValueErr, (Object)this.toolName), (boolean)isContextOk);
    }

    protected void runTest() {
        TestHelper.getExecutionManager((Session)this.getExecutionContext().getSession()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Command cmd = AbstractTableToolStep.this._toolWrapper.createCommand();
                Assert.assertTrue((!UnexecutableCommand.INSTANCE.equals(cmd) ? 1 : 0) != 0);
                cmd.execute();
            }
        });
    }

    public void shouldFail() {
        this.initializeToolAndCheckArguments();
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertFalse((String)NLS.bind((String)Messages.toolWrapperArgumentValueFailedErr, (Object)this.toolName), (boolean)isContextOk);
    }

    public void cannotRun() {
        try {
            this.preRunTest();
            TestHelper.getExecutionManager((Session)this.getExecutionContext().getSession()).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    Command cmd = AbstractTableToolStep.this._toolWrapper.createCommand();
                    Assert.assertTrue((boolean)UnexecutableCommand.INSTANCE.equals(cmd));
                }
            });
        }
        finally {
            this.dispose();
        }
    }

    public AbstractToolDescription getTool(String toolName) {
        TableDescription desc = this.table.getDescription();
        EList tools = new DiagramComponentizationManager().getAllTools(this.sessionContext.getSession().getSelectedViewpoints(true), (DiagramDescription)desc);
        AbstractToolDescription theAbstractToolDescription = null;
        block0: for (AbstractToolDescription current : tools) {
            if (current.getName().equals(toolName)) {
                theAbstractToolDescription = current;
                break;
            }
            if (!(current instanceof PopupMenu)) continue;
            for (MenuItemDescription item : ((PopupMenu)current).getMenuItemDescription()) {
                if (!item.getName().equals(toolName)) continue;
                theAbstractToolDescription = item;
                continue block0;
            }
        }
        return theAbstractToolDescription;
    }
}

