/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDTableStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDTableStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.api.NonDirtyTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.table.ju.utils.AbstractTableActionCommand;
import org.polarsys.capella.test.table.ju.utils.AbstractTableToolStep;
import org.polarsys.capella.test.table.ju.utils.AbstractTableTransactionToolStep;
import org.polarsys.capella.test.table.ju.utils.HideRevealTableElementsCommand;
import org.polarsys.capella.test.table.ju.utils.HideTableElementCommand;
import org.polarsys.capella.test.table.ju.utils.ShowAllTableElementsCommand;
import org.polarsys.capella.test.table.ju.utils.TableTestingHelper;

public abstract class TableTestFramework
extends NonDirtyTestCase {
    protected String existErrMsg = "'{0}' exists even after delete column command is executed";

    public void hideLine(SessionContext context, final DTable table, final EObject obj) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                super.postRunTest();
                DLine line = TableTestingHelper.getLine(table, obj);
                TableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)line.getLabel()), (boolean)line.isVisible());
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                DLine line = TableTestingHelper.getLine(table, obj);
                return new HideTableElementCommand(table, (DTableElement)line, TablePackage.Literals.DLINE__VISIBLE);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void hideColumn(SessionContext context, final DTable table, final EObject obj) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                super.postRunTest();
                DColumn column = TableTestingHelper.getColumn(table, obj);
                TableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)column.getLabel()), (boolean)column.isVisible());
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                DColumn column = TableTestingHelper.getColumn(table, obj);
                return new HideTableElementCommand(table, (DTableElement)column, TablePackage.Literals.DCOLUMN__VISIBLE);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void hideLines(SessionContext context, final DTable table, final List<EObject> visibleElems, final List<EObject> hiddenElems) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                DLine line;
                super.postRunTest();
                for (EObject obj : visibleElems) {
                    line = TableTestingHelper.getLine(table, obj);
                    TableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)line.getLabel()), (boolean)line.isVisible());
                }
                for (EObject obj : hiddenElems) {
                    line = TableTestingHelper.getLine(table, obj);
                    TableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)line.getLabel()), (boolean)line.isVisible());
                }
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                return new HideRevealTableElementsCommand(table, TablePackage.Literals.DLINE__VISIBLE){

                    @Override
                    public List<DTableElement> getVisibleElements() {
                        ArrayList<DTableElement> list = new ArrayList<DTableElement>();
                        for (EObject obj : visibleElems) {
                            list.add((DTableElement)TableTestingHelper.getLine(table, obj));
                        }
                        return list;
                    }
                };
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void hideColumns(SessionContext context, final DTable table, final List<EObject> visibleElems, final List<EObject> hiddenElems) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                DColumn column;
                super.postRunTest();
                for (EObject obj : visibleElems) {
                    column = TableTestingHelper.getColumn(table, obj);
                    TableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)column.getLabel()), (boolean)column.isVisible());
                }
                for (EObject obj : hiddenElems) {
                    column = TableTestingHelper.getColumn(table, obj);
                    TableTestFramework.assertFalse((String)NLS.bind((String)this.tableEltHiddenErrMsg, (Object)column.getLabel()), (boolean)column.isVisible());
                }
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                return new HideRevealTableElementsCommand(table, TablePackage.Literals.DCOLUMN__VISIBLE){

                    @Override
                    public List<DTableElement> getVisibleElements() {
                        ArrayList<DTableElement> list = new ArrayList<DTableElement>();
                        for (EObject obj : visibleElems) {
                            list.add((DTableElement)TableTestingHelper.getColumn(table, obj));
                        }
                        return list;
                    }
                };
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void showAllLines(SessionContext context, final DTable table) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                super.postRunTest();
                List<DLine> allLines = TableTestingHelper.getAllLines((LineContainer)table);
                for (DLine line : allLines) {
                    TableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltVisibleErrMsg, (Object)line.getLabel()), (boolean)line.isVisible());
                }
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                return new ShowAllTableElementsCommand(table, TablePackage.Literals.DLINE__VISIBLE);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void showAllColumns(SessionContext context, final DTable table) {
        new AbstractTableTransactionToolStep(context){

            protected void postRunTest() {
                super.postRunTest();
                EList allColumns = table.getColumns();
                for (DColumn column : allColumns) {
                    TableTestFramework.assertTrue((String)NLS.bind((String)this.tableEltVisibleErrMsg, (Object)column.getLabel()), (boolean)column.isVisible());
                }
            }

            @Override
            protected AbstractTableActionCommand getTableTransactionalCommand() {
                return new ShowAllTableElementsCommand(table, TablePackage.Literals.DCOLUMN__VISIBLE);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void showAllLines(SessionContext context, DTable table, List<EObject> objToCheck) {
        this.showAllLines(context, table);
        for (EObject obj : objToCheck) {
            DLine line = TableTestingHelper.getLine(table, obj);
            TableTestFramework.assertTrue((boolean)line.isVisible());
        }
    }

    public void showAllColumns(SessionContext context, DTable table, List<EObject> objToCheck) {
        this.showAllColumns(context, table);
        for (EObject obj : objToCheck) {
            DColumn column = TableTestingHelper.getColumn(table, obj);
            TableTestFramework.assertTrue((boolean)column.isVisible());
        }
    }

    public void deleteColumn(SessionContext context, DTable table, final EObject obj) {
        new AbstractTableToolStep(context, DescriptionPackage.Literals.DELETE_COLUMN_TOOL, table){

            @Override
            protected void initToolArguments() {
                DColumn container = TableTestingHelper.getColumn(this.table, obj);
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
            }

            protected void postRunTest() {
                TableTestingHelper.refreshTable(this.table);
                super.postRunTest();
                TableTestingHelper.assertCheckObjectOnTable(this.table, Arrays.asList(obj), false);
                TableTestFramework.assertNull((String)NLS.bind((String)TableTestFramework.this.existErrMsg, (Object)EObjectExt.getText((EObject)obj)), (Object)obj.eContainer());
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public void deleteLine(SessionContext context, DTable table, final EObject obj) {
        new AbstractTableToolStep(context, DescriptionPackage.Literals.DELETE_COLUMN_TOOL, table){

            @Override
            protected void initToolArguments() {
                DLine container = TableTestingHelper.getLine(this.table, obj);
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
            }

            protected void postRunTest() {
                TableTestingHelper.refreshTable(this.table);
                super.postRunTest();
                TableTestingHelper.assertCheckObjectOnTable(this.table, Arrays.asList(obj), false);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    public DTable createTable(SessionContext context, String targetId, String diagName) {
        Object result = new CreateDTableStep(context, targetId, diagName).run();
        TableTestFramework.assertTrue((boolean)(result instanceof DTable));
        return (DTable)result;
    }

    public DTable openTable(SessionContext context, String tableName) {
        Object result = new OpenDTableStep(context, tableName).run();
        TableTestFramework.assertTrue((boolean)(result instanceof DTable));
        return (DTable)result;
    }
}

