/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.test.framework.api.CommonTestMessages;

public class TableTestingHelper {
    public static final DLine getLine(DTable table_p, EObject semanticElement_p) {
        List<DLine> lines = TableTestingHelper.getAllLines((LineContainer)table_p);
        for (DLine line : lines) {
            if (line == null || !semanticElement_p.equals(line.getTarget())) continue;
            return line;
        }
        return null;
    }

    public static final DColumn getColumn(DTable table_p, EObject semanticElement_p) {
        for (DColumn column : table_p.getColumns()) {
            if (!semanticElement_p.equals(column.getTarget())) continue;
            return column;
        }
        return null;
    }

    public static final List<DLine> getAllLines(LineContainer container_p) {
        EList lines;
        ArrayList<DLine> returnValue = new ArrayList<DLine>();
        if (container_p != null && (lines = container_p.getLines()) != null) {
            returnValue.addAll((Collection<DLine>)lines);
            for (DLine line : lines) {
                returnValue.addAll(TableTestingHelper.getAllLines((LineContainer)line));
            }
        }
        return returnValue;
    }

    public static final DCell getIntersectionCell(DLine line_p, DColumn column_p) {
        Option cell = TableHelper.getCell((DLine)line_p, (DColumn)column_p);
        return (DCell)cell.get();
    }

    public static final <T extends EObject> T getRecentlyCreatedCapellaElement(EObject parent_p, EReference reference_p) {
        if (!reference_p.isMany()) {
            throw new IllegalArgumentException("Reference \"" + reference_p.getName() + "\" should be many");
        }
        List createdObjects = (List)parent_p.eGet((EStructuralFeature)reference_p);
        int size = createdObjects.size();
        return (T)(size == 0 ? null : (EObject)createdObjects.get(size - 1));
    }

    public static void assertCheckObjectOnTable(DTable table_p, List<EObject> list_p, boolean shouldBeAvailable_p) {
        DLine eObject = null;
        String errMsg = shouldBeAvailable_p ? CommonTestMessages.objectRepresentationNotAvailableOnDiagram : CommonTestMessages.objectRepresentationStillAvailableOnDiagram;
        for (EObject current : list_p) {
            eObject = TableTestingHelper.getLine(table_p, current);
            if (eObject == null) {
                eObject = TableTestingHelper.getColumn(table_p, current);
            }
            Assert.assertTrue((boolean)(shouldBeAvailable_p ? eObject != null : eObject == null));
        }
    }

    public static void refreshTable(final DTable table) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                DialectManager.INSTANCE.refresh((DRepresentation)table, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        TransactionHelper.getExecutionManager((EObject)table).execute((ICommand)cmd);
    }
}

