/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.DeleteColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionFactory;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public class TableToolHelper {
    protected final Session _session;
    protected final DTable _table;

    public TableToolHelper(Session session_p, DTable table_p) {
        this._session = session_p;
        this._table = table_p;
    }

    public AbstractToolDescription getTool(EClass toolEClass_p, String toolName_p) {
        List<AbstractToolDescription> tools = this.getAllTools(this._table.getDescription());
        AbstractToolDescription theAbstractToolDescription = null;
        for (AbstractToolDescription current : tools) {
            if (current.eClass() != toolEClass_p || !current.getName().equals(toolName_p)) continue;
            theAbstractToolDescription = current;
            break;
        }
        return theAbstractToolDescription;
    }

    public AbstractToolDescription getTool(EClass toolEClass_p) {
        List<AbstractToolDescription> tools = this.getAllTools(this._table.getDescription());
        DeleteColumnTool theAbstractToolDescription = null;
        ArrayList<AbstractToolDescription> list = new ArrayList<AbstractToolDescription>();
        for (AbstractToolDescription current : tools) {
            if (current.eClass() != toolEClass_p) continue;
            theAbstractToolDescription = current;
            list.add(current);
            break;
        }
        if (theAbstractToolDescription == null) {
            if (toolEClass_p == DescriptionPackage.Literals.DELETE_COLUMN_TOOL) {
                theAbstractToolDescription = DescriptionFactory.eINSTANCE.createDeleteColumnTool();
            } else if (toolEClass_p == DescriptionPackage.Literals.DELETE_LINE_TOOL) {
                theAbstractToolDescription = DescriptionFactory.eINSTANCE.createDeleteLineTool();
            }
        }
        return theAbstractToolDescription;
    }

    private List<AbstractToolDescription> getAllTools(TableDescription tableDescription_p) {
        ArrayList<AbstractToolDescription> allTools = new ArrayList<AbstractToolDescription>();
        ArrayList<TableMapping> tableMappings = new ArrayList<TableMapping>();
        TreeIterator iter = tableDescription_p.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (obj instanceof AbstractToolDescription) {
                allTools.add((AbstractToolDescription)obj);
            }
            if (!(obj instanceof TableMapping)) continue;
            tableMappings.add((TableMapping)obj);
        }
        for (TableMapping mapping : tableMappings) {
            TreeIterator mappingIter = mapping.eAllContents();
            while (mappingIter.hasNext()) {
                EObject obj = (EObject)mappingIter.next();
                if (!(obj instanceof AbstractToolDescription)) continue;
                allTools.add((AbstractToolDescription)obj);
            }
        }
        return TableToolHelper.removeDuplicates(allTools);
    }

    public static <T extends EObject> List<T> removeDuplicates(List<T> list) {
        HashSet<T> set = new HashSet<T>(list);
        list.clear();
        list.addAll(set);
        return list;
    }
}

