/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases;

import java.util.Optional;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.common.handlers.traceability.LevelBasedTraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.system.handlers.traceability.ReconciliationTraceabilityHandler;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DataPkgReconciliation
extends BasicTestCase {
    CapellaModelSkeleton project1;
    ExecutionManager manager1;
    DataPkg nonPredefinedDataPkg1;
    LiteralNumericValue nonPredefinedValue1;
    CapellaModelSkeleton project2;
    ExecutionManager manager2;
    DataPkg nonPredefinedDataPkg2;
    LiteralNumericValue nonPredefinedValue2;
    LevelBasedTraceabilityHandler.LevelMappingTraceability mappingTraceability;

    public void setUp() throws Exception {
        super.setUp();
        this.manager1 = ExecutionManagerRegistry.getInstance().addNewManager();
        this.project1 = new CapellaModelSkeleton.Builder(this.manager1).build();
        this.nonPredefinedDataPkg1 = InformationFactory.eINSTANCE.createDataPkg("A non-predefined package");
        this.nonPredefinedValue1 = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        this.nonPredefinedValue1.setName("One");
        this.nonPredefinedValue1.setValue("1");
        this.nonPredefinedDataPkg1.getOwnedDataValues().add((Object)this.nonPredefinedValue1);
        this.manager1.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DataPkgReconciliation.this.project1.getSystemAnalysis().getOwnedDataPkg().getOwnedDataPkgs().add((Object)DataPkgReconciliation.this.nonPredefinedDataPkg1);
            }
        });
        this.manager2 = ExecutionManagerRegistry.getInstance().addNewManager();
        this.project2 = new CapellaModelSkeleton.Builder(this.manager2).build();
        this.nonPredefinedDataPkg2 = InformationFactory.eINSTANCE.createDataPkg("A non-predefined package");
        this.nonPredefinedValue2 = DatavalueFactory.eINSTANCE.createLiteralNumericValue();
        this.nonPredefinedValue2.setName("One");
        this.nonPredefinedValue2.setValue("1");
        this.nonPredefinedDataPkg2.getOwnedDataValues().add((Object)this.nonPredefinedValue2);
        this.manager2.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DataPkgReconciliation.this.project2.getSystemAnalysis().getOwnedDataPkg().getOwnedDataPkgs().add((Object)DataPkgReconciliation.this.nonPredefinedDataPkg2);
            }
        });
        DataPkg dataPkg1 = this.project1.getSystemAnalysis().getOwnedDataPkg();
        DataPkg dataPkg2 = this.project2.getSystemAnalysis().getOwnedDataPkg();
        MockLevelBasedTraceabilityHandler levelBasedTraceabilityHandler = new MockLevelBasedTraceabilityHandler("Mock LevelBasedTraceabilityHandler");
        this.mappingTraceability = (LevelBasedTraceabilityHandler.LevelMappingTraceability)levelBasedTraceabilityHandler.createMappingTraceability((EObject)dataPkg1, null, "Mock MappingTraceability");
        MockReconciliationTraceabilityHandler handler = new MockReconciliationTraceabilityHandler("Mock Traceability Handler");
        TransitionContext context = new TransitionContext();
        handler.initializeDataPkg(dataPkg1, dataPkg2, (IContext)context, this.mappingTraceability);
    }

    public void test() throws Exception {
        this.nonPredefinedTypesAreNotMapped(this.mappingTraceability);
        this.predefinedTypesAreMapped(this.mappingTraceability);
    }

    protected void predefinedTypesAreMapped(LevelBasedTraceabilityHandler.LevelMappingTraceability mappingTraceability) {
        DataPkg dataPkg2 = this.project2.getSystemAnalysis().getOwnedDataPkg();
        Optional<DataPkg> predefinedTypesPkgOpt = dataPkg2.getOwnedDataPkgs().stream().filter(pkg -> pkg.getName().equals(NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name)).findFirst();
        DataPkgReconciliation.assertTrue((boolean)predefinedTypesPkgOpt.isPresent());
        TreeIterator eAllContents = predefinedTypesPkgOpt.get().eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            DataPkgReconciliation.assertTrue((boolean)mappingTraceability.containsKey((Object)next));
        }
    }

    protected void nonPredefinedTypesAreNotMapped(LevelBasedTraceabilityHandler.LevelMappingTraceability mappingTraceability) {
        DataPkgReconciliation.assertTrue((!mappingTraceability.containsKey((Object)this.nonPredefinedDataPkg2) ? 1 : 0) != 0);
        TreeIterator eAllContents = this.nonPredefinedDataPkg2.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            DataPkgReconciliation.assertTrue((!mappingTraceability.containsKey((Object)next) ? 1 : 0) != 0);
        }
    }

    public void tearDown() throws Exception {
        ExecutionManagerRegistry.getInstance().removeManager(this.manager1);
        ExecutionManagerRegistry.getInstance().removeManager(this.manager2);
        super.tearDown();
    }

    class MockLevelBasedTraceabilityHandler
    extends LevelBasedTraceabilityHandler {
        public MockLevelBasedTraceabilityHandler(String identifier) {
            super(identifier);
        }

        public MappingTraceability createMappingTraceability(EObject source, IContext context, String key) {
            return super.createMappingTraceability(source, context, key);
        }
    }

    class MockReconciliationTraceabilityHandler
    extends ReconciliationTraceabilityHandler {
        public MockReconciliationTraceabilityHandler(String identifier) {
            super(identifier);
        }

        public void initializeDataPkg(DataPkg source, DataPkg target, IContext context, LevelBasedTraceabilityHandler.LevelMappingTraceability map) {
            super.initializeDataPkg(source, target, context, map);
        }
    }
}

