/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.data.requirement.RequirementsPkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;
import org.polarsys.capella.test.transition.ju.model.EmptySkeletonProject;

public class SkeletonElementsNames
extends EmptySkeletonProject {
    private static String CUSTOM_NAME = "CUSTOM";

    public void performTest() throws Exception {
        this.checkRootFunctionPkg("c2c5e86f-7100-45cd-af40-b89a2c78c212");
        this.checkRootFunction("c2c5e86f-7100-45cd-af40-b89a2c78c212");
        this.checkRootFunctionPkg("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkRootFunction("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkRootFunctionPkg("9268f7fc-10e6-4f7c-bdec-cc843c177891");
        this.checkRootFunction("9268f7fc-10e6-4f7c-bdec-cc843c177891");
        this.checkActorPkg("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkActorPkg("9268f7fc-10e6-4f7c-bdec-cc843c177891");
        this.checkDataPkg("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkDataPkg("9268f7fc-10e6-4f7c-bdec-cc843c177891");
        this.checkInterfacePkg("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkInterfacePkg("9268f7fc-10e6-4f7c-bdec-cc843c177891");
        this.checkCapabilityPkg("c2c5e86f-7100-45cd-af40-b89a2c78c212");
        this.checkCapabilityPkg("70205a59-a948-4d13-90d7-f42bd45369e3");
        this.checkCapabilityPkg("9268f7fc-10e6-4f7c-bdec-cc843c177891");
    }

    protected void setName(String elementId, String name) {
        ((AbstractNamedElement)this.getObject(elementId)).setName(name);
    }

    protected void checkRootFunctionPkg(String containerId) {
        SkeletonHelper.createFunctionPkg((String)containerId, (String)GenericModel.FUNCTION_PKG, (SessionContext)this.context);
        EObject result = null;
        this.performFunctionalTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.FUNCTION_PKG);
        this.checkDefaultName(result);
        EObjectHelper.removeElement(result);
        this.setName(GenericModel.FUNCTION_PKG, CUSTOM_NAME);
        this.performFunctionalTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.FUNCTION_PKG);
        this.mustBeNamed(result, CUSTOM_NAME);
        EObjectHelper.removeElement(result);
        EObjectHelper.removeElement((String)GenericModel.FUNCTION_PKG, (SessionContext)this.context);
    }

    protected void checkRootFunction(String containerId) {
        SkeletonHelper.createFunctionPkg((String)containerId, (String)GenericModel.FUNCTION_PKG, (SessionContext)this.context);
        SkeletonHelper.createRootFunction((String)GenericModel.FUNCTION_PKG, (String)GenericModel.FUNCTION_1, (SessionContext)this.context);
        EObject result = null;
        this.performFunctionalTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.FUNCTION_1);
        this.checkDefaultName(result);
        EObjectHelper.removeElement(result);
        this.setName(GenericModel.FUNCTION_1, CUSTOM_NAME);
        this.performFunctionalTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.FUNCTION_1);
        this.mustBeNamed(result, CUSTOM_NAME);
        EObjectHelper.removeElement(result);
        EObjectHelper.removeElement((String)GenericModel.FUNCTION_PKG, (SessionContext)this.context);
    }

    protected void checkActorPkg(String containerId) {
        boolean isTransitionable = TransitionCommandHelper.getInstance().isActorTransitionAvailable(this.getObject(containerId));
        SkeletonElementsNames.assertFalse((String)"Can not perform actor transition on Architecture without any actor under it", (boolean)isTransitionable);
    }

    protected void checkDataPkg(String containerId) {
        SkeletonHelper.createDataPkg((String)containerId, (String)GenericModel.DATA_PKG, (SessionContext)this.context);
        EObject result = null;
        this.performDataTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.DATA_PKG);
        this.checkDefaultName(result);
        EObjectHelper.removeElement(result);
        this.setName(GenericModel.DATA_PKG, CUSTOM_NAME);
        this.performDataTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.DATA_PKG);
        this.mustBeNamed(result, CUSTOM_NAME);
        EObjectHelper.removeElement(result);
        EObjectHelper.removeElement((String)GenericModel.DATA_PKG, (SessionContext)this.context);
    }

    protected void checkInterfacePkg(String containerId) {
        SkeletonHelper.createInterfacePkg((String)containerId, (String)GenericModel.INTERFACE_PKG, (SessionContext)this.context);
        EObject result = null;
        this.performInterfaceTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.INTERFACE_PKG);
        this.startWithName(result, NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        EObjectHelper.removeElement(result);
        this.setName(GenericModel.INTERFACE_PKG, CUSTOM_NAME);
        this.performInterfaceTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.INTERFACE_PKG);
        this.startWithName(result, CUSTOM_NAME);
        EObjectHelper.removeElement(result);
        EObjectHelper.removeElement((String)GenericModel.INTERFACE_PKG, (SessionContext)this.context);
    }

    protected void checkCapabilityPkg(String containerId) {
        SkeletonHelper.createCapabilityPkg((String)containerId, (String)GenericModel.CAPABILITY_PKG, (SessionContext)this.context);
        EObject result = null;
        this.performCapabilityTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.CAPABILITY_PKG);
        this.checkDefaultName(result);
        EObjectHelper.removeElement(result);
        this.setName(GenericModel.CAPABILITY_PKG, CUSTOM_NAME);
        this.performCapabilityTransition(this.getObjects(new String[]{containerId}));
        result = (EObject)this.mustBeTransitioned(GenericModel.CAPABILITY_PKG);
        this.mustBeNamed(result, CUSTOM_NAME);
        EObjectHelper.removeElement(result);
        EObjectHelper.removeElement((String)GenericModel.CAPABILITY_PKG, (SessionContext)this.context);
    }

    protected void startWithName(EObject result, String name) {
        SkeletonElementsNames.assertTrue((boolean)((AbstractNamedElement)result).getName().startsWith(name));
    }

    protected void checkDefaultName(EObject result) {
        if (result instanceof OperationalActivityPkg) {
            this.mustBeNamed(result, NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name);
        } else if (result instanceof SystemFunctionPkg) {
            this.mustBeNamed(result, NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name);
        } else if (result instanceof LogicalFunctionPkg) {
            this.mustBeNamed(result, NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name);
        } else if (result instanceof PhysicalFunctionPkg) {
            this.mustBeNamed(result, NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name);
        } else if (result instanceof OperationalActivity) {
            this.mustBeNamed(result, NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name);
        } else if (result instanceof SystemFunction) {
            this.mustBeNamed(result, NamingConstants.CreateSysAnalysisCmd_system_function_root_name);
        } else if (result instanceof LogicalFunction) {
            this.mustBeNamed(result, NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name);
        } else if (result instanceof PhysicalFunction) {
            this.mustBeNamed(result, NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name);
        } else if (result instanceof EntityPkg) {
            this.mustBeNamed(result, NamingConstants.CreateOpAnalysisCmd_operationalEntities_pkg_name);
        } else if (result instanceof SystemComponentPkg) {
            this.mustBeNamed(result, NamingConstants.CreateSysAnalysisCmd_actors_pkg_name);
        } else if (result instanceof LogicalComponentPkg) {
            this.mustBeNamed(result, NamingConstants.CreateLogicalArchCmd_actors_pkg_name);
        } else if (result instanceof PhysicalComponentPkg) {
            this.mustBeNamed(result, NamingConstants.CreatePhysicalArchCmd_actors_pkg_name);
        } else if (result instanceof OperationalCapabilityPkg) {
            this.mustBeNamed(result, NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name);
        } else if (result instanceof CapabilityPkg) {
            this.mustBeNamed(result, NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name);
        } else if (result instanceof CapabilityRealizationPkg) {
            this.mustBeNamed(result, NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
        } else if (result instanceof MissionPkg) {
            this.mustBeNamed(result, NamingConstants.CreateSysAnalysisCmd_missions_pkg_name);
        } else if (result instanceof DataPkg) {
            this.mustBeNamed(result, NamingConstants.CreateCommonCmd_data_pkg_name);
        } else if (result instanceof InterfacePkg) {
            this.mustBeNamed(result, NamingConstants.CreateCommonCmd_interfaces_pkg_name);
        } else if (result instanceof RequirementsPkg) {
            this.mustBeNamed(result, NamingConstants.CreateCommonCmd_requirements_pkg_name);
        }
    }
}

