/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class DataTransition
extends TopDownTransitionTestCase {
    private DataPkg laDataPkg;
    private DataPkg laMyDataPkg;
    private Class laPrimitiveClass;
    private Class laSuperClass;
    private Class laSubClass;
    private Class laUnion;
    private Collection laMyCollection;
    private Service laMyService;
    private Parameter laMyParameter;
    private BooleanType laMyBooleanType;
    private LiteralBooleanValue laFalseValue;
    private LiteralBooleanValue laTrueValue;
    private StringType laSuperST;
    private StringType laSubST;
    private Property laProperty1;
    private Service laService1;
    private Parameter laParameter1;
    private Service laService2;
    private Parameter laParameter2;
    private Constraint laConstraint1;
    private DataPkg paDataPkg;
    private DataPkg paMyDataPkg;
    private Class paPrimitiveClass;
    private Class paSuperClass;
    private Class paSubClass;
    private Class paUnion;
    private Collection paMyCollection;
    private Service paMyService;
    private Parameter paMyParameter;
    private BooleanType paMyBooleanType;
    private LiteralBooleanValue paFalseValue;
    private LiteralBooleanValue paTrueValue;
    private StringType paSuperST;
    private StringType paSubST;
    private Property paProperty1;
    private Service paService1;
    private Parameter paParameter1;
    private Service paService2;
    private Constraint paConstraint1;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laDataPkg = (DataPkg)this.getObject(ModelLaPa.laDataPkgId);
        this.laPrimitiveClass = (Class)this.getObject(ModelLaPa.primitiveClassId);
        this.laSuperClass = (Class)this.getObject(ModelLaPa.superClassId);
        this.laSubClass = (Class)this.getObject(ModelLaPa.subClassId);
        this.laSuperST = (StringType)this.getObject(ModelLaPa.superSTId);
        this.laSubST = (StringType)this.getObject(ModelLaPa.subSTId);
        this.laProperty1 = (Property)this.getObject(ModelLaPa.property1Id);
        this.laService1 = (Service)this.getObject(ModelLaPa.service1Id);
        this.laParameter1 = (Parameter)this.getObject(ModelLaPa.parameter1Id);
        this.laService2 = (Service)this.getObject(ModelLaPa.service2Id);
        this.laConstraint1 = (Constraint)this.getObject(ModelLaPa.constraint1Id);
        this.paDataPkg = (DataPkg)this.getObject(ModelLaPa.paDataPkgId);
        this.laMyDataPkg = (DataPkg)this.getObject(ModelLaPa.laMyDataPkgId);
        this.laMyCollection = (Collection)this.getObject(ModelLaPa.laMyCollectionId);
        this.laMyService = (Service)this.getObject(ModelLaPa.laMyServiceId);
        this.laMyParameter = (Parameter)this.getObject(ModelLaPa.laMyParameterId);
        this.laMyBooleanType = (BooleanType)this.getObject(ModelLaPa.laMyBooleanTypeId);
        this.laFalseValue = (LiteralBooleanValue)this.getObject(ModelLaPa.laFalseValueId);
        this.laTrueValue = (LiteralBooleanValue)this.getObject(ModelLaPa.laTrueValueId);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.initSession();
        this.myCollectionTransitionTest();
        this.primitiveClassTransitionTest();
        this.subClassTransition1Test();
        this.laDataPkgTransitionTest();
        this.subClassTransition2Test();
    }

    private void myCollectionTransitionTest() {
        this.performDataTransition(Arrays.asList(this.laMyCollection));
        this.paMyDataPkg = (DataPkg)this.paDataPkg.getOwnedDataPkgs().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paMyDataPkg);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMyDataPkg.getName(), (Object)this.laMyDataPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMyDataPkg) == this.laMyDataPkg ? 1 : 0) != 0);
        this.paMyBooleanType = (BooleanType)this.paMyDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paMyBooleanType);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMyBooleanType.getName(), (Object)this.laMyBooleanType.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMyBooleanType) == this.laMyBooleanType ? 1 : 0) != 0);
        this.paFalseValue = (LiteralBooleanValue)this.paMyBooleanType.getOwnedLiterals().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paFalseValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFalseValue.getName(), (Object)this.laFalseValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFalseValue) == this.laFalseValue ? 1 : 0) != 0);
        DataTransition.assertFalse((String)NLS.bind((String)Messages.WrongValue, (Object)this.paFalseValue.getName()), (boolean)this.paFalseValue.isValue());
        this.paTrueValue = (LiteralBooleanValue)this.paMyBooleanType.getOwnedLiterals().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paTrueValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paTrueValue.getName(), (Object)this.laTrueValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paTrueValue) == this.laTrueValue ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongValue, (Object)this.paTrueValue.getName()), (boolean)this.paTrueValue.isValue());
        this.paMyCollection = (Collection)this.paDataPkg.getOwnedCollections().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paMyCollection);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMyCollection.getName(), (Object)this.laMyCollection.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMyCollection) == this.laMyCollection ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paMyCollection.getName(), (Object)this.paMyBooleanType.getName()), (this.paMyCollection.getType() == this.paMyBooleanType ? 1 : 0) != 0);
        this.paMyService = (Service)this.paMyCollection.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paMyService);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMyService.getName(), (Object)this.laMyService.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMyService) == this.laMyService ? 1 : 0) != 0);
        this.paMyParameter = (Parameter)this.paMyService.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paMyParameter);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paMyParameter.getName(), (Object)this.laMyParameter.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paMyParameter) == this.laMyParameter ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paMyParameter.getName(), (Object)this.paMyBooleanType.getName()), (this.paMyParameter.getType() == this.paMyBooleanType ? 1 : 0) != 0);
    }

    private void primitiveClassTransitionTest() {
        this.performDataTransition(Arrays.asList(this.laPrimitiveClass));
        this.paPrimitiveClass = ProjectionTestUtils.getRecentlyAddedClass(this.paDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paPrimitiveClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paPrimitiveClass.getName(), (Object)this.laPrimitiveClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paPrimitiveClass) == this.laPrimitiveClass ? 1 : 0) != 0);
    }

    private void subClassTransition1Test() {
        this.performDataTransition(Arrays.asList(this.laSubClass));
        this.paSuperST = (StringType)this.paDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSuperST.getName(), (Object)this.laSuperST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSuperST) == this.laSuperST ? 1 : 0) != 0);
        this.paSubST = (StringType)CodeHelper.getChildTracingElement((EObject)this.paDataPkg, (EObject)this.laSubST);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubST.getName(), (Object)this.laSubST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubST) == this.laSubST ? 1 : 0) != 0);
        this.paSubClass = (Class)CodeHelper.getChildTracingElement((EObject)this.paDataPkg, (EObject)this.laSubClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paSubClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubClass.getName(), (Object)this.laSubClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubClass) == this.laSubClass ? 1 : 0) != 0);
        this.paService1 = (Service)this.paSubClass.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paService1.getName(), (Object)this.laService1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paService1) == this.laService1 ? 1 : 0) != 0);
        this.paParameter1 = (Parameter)this.paService1.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paParameter1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paParameter1.getName(), (Object)this.laParameter1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paParameter1) == this.laParameter1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paParameter1.getName(), (Object)this.paSuperST.getName()), (this.paParameter1.getType() == this.paSuperST ? 1 : 0) != 0);
        this.paService2 = (Service)this.paSubClass.getContainedOperations().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paService2);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paService2.getName(), (Object)this.laService2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paService2) == this.laService2 ? 1 : 0) != 0);
        this.paSuperClass = (Class)CodeHelper.getChildTracingElement((EObject)this.paDataPkg, (EObject)this.laSuperClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSuperClass.getName(), (Object)this.laSuperClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSuperClass) == this.laSuperClass ? 1 : 0) != 0);
        this.paProperty1 = (Property)this.paSuperClass.getContainedProperties().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paProperty1.getName(), (Object)this.laProperty1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paProperty1) == this.laProperty1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paProperty1.getName(), (Object)this.paSubST.getName()), (this.paProperty1.getType() == this.paSubST ? 1 : 0) != 0);
        this.paConstraint1 = (Constraint)this.paSubClass.getOwnedConstraints().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paConstraint1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paConstraint1.getName(), (Object)this.laConstraint1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paConstraint1) == this.laConstraint1 ? 1 : 0) != 0);
    }

    private void laDataPkgTransitionTest() {
        this.performDataTransition(Arrays.asList(this.laDataPkg));
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this.laDataPkg.getOwnedClasses().size(), (int)this.paDataPkg.getOwnedClasses().size());
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this.laDataPkg.getOwnedDataTypes().size(), (int)this.paDataPkg.getOwnedDataTypes().size());
    }

    private void subClassTransition2Test() {
        this.laService1.destroy();
        this.laUnion = InformationFactory.eINSTANCE.createUnion("Union1");
        this.laDataPkg.getOwnedClasses().add((Object)this.laUnion);
        this.laParameter2 = InformationFactory.eINSTANCE.createParameter("Parameter2");
        this.laParameter2.setAbstractType((AbstractType)this.laUnion);
        this.laService2.getOwnedParameters().add((Object)this.laParameter2);
        this.performDataTransition(Arrays.asList(this.laSubClass));
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paService1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paService1) == null ? 1 : 0) != 0);
        this.paUnion = ProjectionTestUtils.getRecentlyAddedClass(this.paDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this.paUnion);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paUnion.getName(), (Object)this.laUnion.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paUnion) == this.laUnion ? 1 : 0) != 0);
    }
}

