/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class InterfaceTransition
extends TopDownTransitionTestCase {
    private InterfacePkg rootLogicalIntPkg;
    private Interface laInterface1;
    private Interface laInterface2;
    private Interface laSubInterface;
    private Interface laSuperInterface;
    private ExchangeItem laEventEI;
    private ExchangeItem laOperationEI;
    private ExchangeItem laFlowEI;
    private ExchangeItem laDataEI;
    private BooleanType laBT1;
    private Collection laCollection1;
    private ExchangeItemElement laExchEltBT1;
    private ExchangeItemElement laExchEltColl1;
    private ExchangeItemAllocation laEventEIAlloc;
    private ExchangeItemAllocation laOperationEIAlloc;
    private ExchangeItemAllocation laFlowEIAlloc;
    private ExchangeItemAllocation laDataEIAlloc;
    private Interface laLeafInterface;
    private InterfacePkg laSubIntPkg;
    private Interface laInnerInt1;
    private Interface laInnerInt2;
    private ExchangeItem laUndefinedEI;
    private ExchangeItemAllocation laUndefinedEIAlloc;
    private InterfacePkg rootPhysicalIntPkg;
    private InterfacePkg paLogicalInterfacesPkg;
    private Interface paInterface1;
    private Interface paInterface2;
    private Interface paSubInterface;
    private Interface paSuperInterface;
    private ExchangeItem paEventEI;
    private ExchangeItem paOperationEI;
    private ExchangeItem paFlowEI;
    private ExchangeItem paDataEI;
    private ExchangeItemElement paExchEltBT1;
    private ExchangeItemElement paExchEltColl1;
    private ExchangeItemAllocation paEventEIAlloc;
    private ExchangeItemAllocation paOperationEIAlloc;
    private ExchangeItemAllocation paFlowEIAlloc;
    private ExchangeItemAllocation paDataEIAlloc;
    private Interface paLeafInterface;
    private InterfacePkg paSubIntPkg;
    private Interface paInnerInt1;
    private Interface paInnerInt2;
    private ExchangeItem paUndefinedEI;
    private ExchangeItemAllocation paUndefinedEIAlloc;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.setPreferenceValue("projection.exchangeItems", true);
        this.setPreferenceValue("projection.dataType", false);
        this.rootLogicalIntPkg = (InterfacePkg)this.getObject(ModelLaPa.rootLogicalIntPkgId);
        this.laInterface1 = (Interface)this.getObject(ModelLaPa.interface1Id);
        this.laInterface2 = (Interface)this.getObject(ModelLaPa.interface2Id);
        this.laSubInterface = (Interface)this.getObject(ModelLaPa.subInterfaceId);
        this.laSuperInterface = (Interface)this.getObject(ModelLaPa.superInterfaceId);
        this.laEventEI = (ExchangeItem)this.getObject(ModelLaPa.eventEIId);
        this.laOperationEI = (ExchangeItem)this.getObject(ModelLaPa.operationEIId);
        this.laFlowEI = (ExchangeItem)this.getObject(ModelLaPa.flowEIId);
        this.laDataEI = (ExchangeItem)this.getObject(ModelLaPa.dataEIId);
        this.laBT1 = (BooleanType)this.getObject(ModelLaPa.bt1Id);
        this.laCollection1 = (Collection)this.getObject(ModelLaPa.collection1Id);
        this.laExchEltBT1 = (ExchangeItemElement)this.getObject(ModelLaPa.exchEltBT1Id);
        this.laExchEltColl1 = (ExchangeItemElement)this.getObject(ModelLaPa.exchEltColl1Id);
        this.laEventEIAlloc = (ExchangeItemAllocation)this.getObject(ModelLaPa.eventEIAllocId);
        this.laOperationEIAlloc = (ExchangeItemAllocation)this.getObject(ModelLaPa.operationEIAllocId);
        this.laFlowEIAlloc = (ExchangeItemAllocation)this.getObject(ModelLaPa.flowEIAllocId);
        this.laDataEIAlloc = (ExchangeItemAllocation)this.getObject(ModelLaPa.dataEIAllocId);
        this.laLeafInterface = (Interface)this.getObject(ModelLaPa.leafInterfaceId);
        this.laSubIntPkg = (InterfacePkg)this.getObject(ModelLaPa.subIntPkgId);
        this.laInnerInt1 = (Interface)this.getObject(ModelLaPa.innerInt1Id);
        this.laUndefinedEI = (ExchangeItem)this.getObject(ModelLaPa.undefinedEIId);
        this.laUndefinedEIAlloc = (ExchangeItemAllocation)this.getObject(ModelLaPa.undefinedEIAllocId);
        this.rootPhysicalIntPkg = (InterfacePkg)this.getObject(ModelLaPa.rootPhysicalIntPkgId);
    }

    public void performTest() throws Exception {
        this.initSession();
        this.leafInterfaceTransitionTest();
        this.innerIntTransitionTest();
        this.subInterfaceTransitionTest();
        this.rootInterfacePkgTransitionTest();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    private void leafInterfaceTransitionTest() {
        this.performInterfaceTransition(Arrays.asList(this.laLeafInterface));
        this.paLogicalInterfacesPkg = (InterfacePkg)this.rootPhysicalIntPkg.getOwnedInterfacePkgs().get(0);
        this.mustNotBeNull((EObject)this.paLogicalInterfacesPkg);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paLogicalInterfacesPkg.getName(), (Object)this.rootLogicalIntPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paLogicalInterfacesPkg) == this.rootLogicalIntPkg ? 1 : 0) != 0);
        this.paLeafInterface = (Interface)this.paLogicalInterfacesPkg.getOwnedInterfaces().get(0);
        this.mustNotBeNull((EObject)this.paLeafInterface);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paLeafInterface.getName(), (Object)this.laLeafInterface.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paLeafInterface) == this.laLeafInterface ? 1 : 0) != 0);
    }

    private void innerIntTransitionTest() {
        this.performInterfaceTransition(Arrays.asList(this.laInnerInt1));
        this.paSubIntPkg = (InterfacePkg)this.paLogicalInterfacesPkg.getOwnedInterfacePkgs().get(0);
        this.mustNotBeNull((EObject)this.paSubIntPkg);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubIntPkg.getName(), (Object)this.laSubIntPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubIntPkg) == this.laSubIntPkg ? 1 : 0) != 0);
        this.paInnerInt1 = (Interface)this.paSubIntPkg.getOwnedInterfaces().get(0);
        this.mustNotBeNull((EObject)this.paInnerInt1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInnerInt1.getName(), (Object)this.laInnerInt1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInnerInt1) == this.laInnerInt1 ? 1 : 0) != 0);
        this.paUndefinedEI = (ExchangeItem)this.paSubIntPkg.getOwnedExchangeItems().get(0);
        this.mustNotBeNull((EObject)this.paUndefinedEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paUndefinedEI.getName(), (Object)this.laUndefinedEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paUndefinedEI) == this.laUndefinedEI ? 1 : 0) != 0);
        this.paUndefinedEIAlloc = (ExchangeItemAllocation)this.paInnerInt1.getOwnedExchangeItemAllocations().get(0);
        this.mustNotBeNull((EObject)this.paUndefinedEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paUndefinedEIAlloc, (Object)this.laUndefinedEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paUndefinedEIAlloc) == this.laUndefinedEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.laUndefinedEI, (Object)this.paInnerInt1), (this.paUndefinedEIAlloc.getAllocatedItem() == this.paUndefinedEI ? 1 : 0) != 0);
    }

    private void subInterfaceTransitionTest() {
        this.performInterfaceTransition(Arrays.asList(this.laSubInterface));
        this.paSubInterface = ProjectionTestUtils.getAllocatingInterface(this.laSubInterface);
        this.mustNotBeNull((EObject)this.paSubInterface);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubInterface.getName(), (Object)this.laSubInterface.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubInterface) == this.laSubInterface ? 1 : 0) != 0);
        this.paSuperInterface = ProjectionTestUtils.getAllocatingInterface(this.laSuperInterface);
        this.mustNotBeNull((EObject)this.paSuperInterface);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSuperInterface.getName(), (Object)this.laSuperInterface.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSuperInterface) == this.laSuperInterface ? 1 : 0) != 0);
        int projectedInterfaceSize = 3;
        InterfaceTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)projectedInterfaceSize), (int)projectedInterfaceSize, (int)this.paLogicalInterfacesPkg.getOwnedInterfaces().size());
        InterfaceTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)4), (int)4, (int)this.paLogicalInterfacesPkg.getOwnedExchangeItems().size());
        this.paEventEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laEventEI);
        this.mustNotBeNull((EObject)this.paEventEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paEventEI.getName(), (Object)this.laEventEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paEventEI) == this.laEventEI ? 1 : 0) != 0);
        this.paExchEltBT1 = (ExchangeItemElement)this.paEventEI.getOwnedElements().get(0);
        this.mustNotBeNull((EObject)this.paExchEltBT1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paExchEltBT1.getName(), (Object)this.laExchEltBT1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paExchEltBT1) == this.laExchEltBT1 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paExchEltBT1.getName(), (Object)this.laBT1.getName()), (this.paExchEltBT1.getAbstractType() == this.laBT1 ? 1 : 0) != 0);
        this.paOperationEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laOperationEI);
        this.mustNotBeNull((EObject)this.paOperationEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paOperationEI.getName(), (Object)this.laOperationEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paOperationEI) == this.laOperationEI ? 1 : 0) != 0);
        this.paFlowEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laFlowEI);
        this.mustNotBeNull((EObject)this.paFlowEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFlowEI.getName(), (Object)this.laFlowEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFlowEI) == this.laFlowEI ? 1 : 0) != 0);
        this.paExchEltColl1 = (ExchangeItemElement)this.paFlowEI.getOwnedElements().get(0);
        this.mustNotBeNull((EObject)this.paExchEltColl1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paExchEltColl1.getName(), (Object)this.laExchEltColl1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paExchEltColl1) == this.laExchEltColl1 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paExchEltColl1.getName(), (Object)this.laCollection1.getName()), (this.paExchEltColl1.getAbstractType() == this.laCollection1 ? 1 : 0) != 0);
        this.paDataEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laDataEI);
        this.mustNotBeNull((EObject)this.paDataEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paDataEI.getName(), (Object)this.laDataEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paDataEI) == this.laDataEI ? 1 : 0) != 0);
        this.paOperationEIAlloc = (ExchangeItemAllocation)this.paSubInterface.getOwnedExchangeItemAllocations().get(0);
        this.mustNotBeNull((EObject)this.paOperationEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paOperationEIAlloc, (Object)this.laOperationEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paOperationEIAlloc) == this.laOperationEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.paOperationEIAlloc, (Object)this.paSubInterface), (this.paOperationEIAlloc.getAllocatedItem() == this.paOperationEI ? 1 : 0) != 0);
        this.paEventEIAlloc = (ExchangeItemAllocation)this.paSubInterface.getOwnedExchangeItemAllocations().get(1);
        this.mustNotBeNull((EObject)this.paEventEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paEventEIAlloc, (Object)this.laEventEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paEventEIAlloc) == this.laEventEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.paEventEIAlloc, (Object)this.paSubInterface), (this.paEventEIAlloc.getAllocatedItem() == this.paEventEI ? 1 : 0) != 0);
        this.paFlowEIAlloc = (ExchangeItemAllocation)this.paSuperInterface.getOwnedExchangeItemAllocations().get(1);
        this.mustNotBeNull((EObject)this.paFlowEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFlowEIAlloc, (Object)this.laFlowEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFlowEIAlloc) == this.laFlowEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.paFlowEIAlloc, (Object)this.paSubInterface), (this.paFlowEIAlloc.getAllocatedItem() == this.paFlowEI ? 1 : 0) != 0);
        this.paDataEIAlloc = (ExchangeItemAllocation)this.paSuperInterface.getOwnedExchangeItemAllocations().get(0);
        this.mustNotBeNull((EObject)this.paDataEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paDataEIAlloc, (Object)this.laDataEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paDataEIAlloc) == this.laDataEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.paDataEIAlloc, (Object)this.paSubInterface), (this.paDataEIAlloc.getAllocatedItem() == this.paDataEI ? 1 : 0) != 0);
    }

    private void rootInterfacePkgTransitionTest() {
        this.paFlowEI.destroy();
        this.laInnerInt2 = CsFactory.eINSTANCE.createInterface("Inner INT2");
        this.laSubIntPkg.getOwnedInterfaces().add((Object)this.laInnerInt2);
        ExchangeItemAllocation leafIntEventEIAlloc = CsFactory.eINSTANCE.createExchangeItemAllocation();
        leafIntEventEIAlloc.setAllocatedItem(this.laEventEI);
        this.laLeafInterface.getOwnedExchangeItemAllocations().add((Object)leafIntEventEIAlloc);
        ExchangeItemAllocation leafIntOperationEIAlloc = CsFactory.eINSTANCE.createExchangeItemAllocation();
        leafIntOperationEIAlloc.setAllocatedItem(this.laOperationEI);
        this.laLeafInterface.getOwnedExchangeItemAllocations().add((Object)leafIntOperationEIAlloc);
        ExchangeItemAllocation leafIntFlowEIAlloc = CsFactory.eINSTANCE.createExchangeItemAllocation();
        leafIntFlowEIAlloc.setAllocatedItem(this.laFlowEI);
        this.laLeafInterface.getOwnedExchangeItemAllocations().add((Object)leafIntFlowEIAlloc);
        ExchangeItemAllocation leafIntDataEIAlloc = CsFactory.eINSTANCE.createExchangeItemAllocation();
        leafIntDataEIAlloc.setAllocatedItem(this.laDataEI);
        this.laLeafInterface.getOwnedExchangeItemAllocations().add((Object)leafIntDataEIAlloc);
        this.performInterfaceTransition(Arrays.asList(this.rootLogicalIntPkg));
        this.paInterface1 = ProjectionTestUtils.getAllocatingInterface(this.laInterface1);
        this.mustNotBeNull((EObject)this.paInterface1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInterface1.getName(), (Object)this.laInterface1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInterface1) == this.laInterface1 ? 1 : 0) != 0);
        this.paInterface2 = ProjectionTestUtils.getAllocatingInterface(this.laInterface2);
        this.mustNotBeNull((EObject)this.paInterface2);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInterface2.getName(), (Object)this.laInterface2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInterface2) == this.laInterface2 ? 1 : 0) != 0);
        int projectedInterfaceSize = 5;
        InterfaceTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)projectedInterfaceSize), (int)this.paLogicalInterfacesPkg.getOwnedInterfaces().size(), (int)projectedInterfaceSize);
        int projectedExchangeItemSize = 4;
        InterfaceTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)projectedExchangeItemSize), (int)this.paLogicalInterfacesPkg.getOwnedExchangeItems().size(), (int)projectedExchangeItemSize);
        this.paFlowEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laFlowEI);
        this.mustNotBeNull((EObject)this.paFlowEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFlowEI.getName(), (Object)this.laFlowEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFlowEI) == this.laFlowEI ? 1 : 0) != 0);
        this.paEventEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laEventEI);
        this.mustNotBeNull((EObject)this.paEventEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paEventEI.getName(), (Object)this.laEventEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paEventEI) == this.laEventEI ? 1 : 0) != 0);
        this.paOperationEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laOperationEI);
        this.mustNotBeNull((EObject)this.paOperationEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paOperationEI.getName(), (Object)this.laOperationEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paOperationEI) == this.laOperationEI ? 1 : 0) != 0);
        this.paFlowEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laFlowEI);
        this.mustNotBeNull((EObject)this.paFlowEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFlowEI.getName(), (Object)this.laFlowEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFlowEI) == this.laFlowEI ? 1 : 0) != 0);
        this.paDataEI = ProjectionTestUtils.getAllocatingExchangeItem(this.laDataEI);
        this.mustNotBeNull((EObject)this.paDataEI);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paDataEI.getName(), (Object)this.laDataEI.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paDataEI) == this.laDataEI ? 1 : 0) != 0);
        this.paExchEltColl1 = (ExchangeItemElement)this.paFlowEI.getOwnedElements().get(0);
        this.mustNotBeNull((EObject)this.paExchEltColl1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paExchEltColl1.getName(), (Object)this.laExchEltColl1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paExchEltColl1) == this.laExchEltColl1 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paExchEltColl1.getName(), (Object)this.laCollection1.getName()), (this.paExchEltColl1.getAbstractType() == this.laCollection1 ? 1 : 0) != 0);
        this.paFlowEIAlloc = (ExchangeItemAllocation)this.paSuperInterface.getOwnedExchangeItemAllocations().get(1);
        this.mustNotBeNull((EObject)this.paFlowEIAlloc);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFlowEIAlloc, (Object)this.laFlowEIAlloc), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFlowEIAlloc) == this.laFlowEIAlloc ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongAllocation, (Object)this.paFlowEIAlloc, (Object)this.paSubInterface), (this.paFlowEIAlloc.getAllocatedItem() == this.paFlowEI ? 1 : 0) != 0);
        this.paInnerInt2 = (Interface)this.paSubIntPkg.getOwnedInterfaces().get(1);
        this.mustNotBeNull((EObject)this.paInnerInt2);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInnerInt2, (Object)this.laInnerInt2), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInnerInt2) == this.laInnerInt2 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)Messages.WrongAllocation, (boolean)this.paLeafInterface.getExchangeItems().containsAll(Arrays.asList(this.paFlowEI, this.paDataEI, this.paEventEI, this.paOperationEI)));
        this.paExchEltBT1 = (ExchangeItemElement)this.paEventEI.getOwnedElements().get(0);
        this.mustNotBeNull((EObject)this.paExchEltBT1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paExchEltBT1.getName(), (Object)this.laExchEltBT1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paExchEltBT1) == this.laExchEltBT1 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paExchEltBT1.getName(), (Object)this.laBT1.getName()), (this.paExchEltBT1.getAbstractType() == this.laBT1 ? 1 : 0) != 0);
        this.paExchEltColl1 = (ExchangeItemElement)this.paFlowEI.getOwnedElements().get(0);
        this.mustNotBeNull((EObject)this.paExchEltColl1);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paExchEltColl1.getName(), (Object)this.laExchEltColl1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paExchEltColl1) == this.laExchEltColl1 ? 1 : 0) != 0);
        InterfaceTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this.paExchEltColl1.getName(), (Object)this.laCollection1.getName()), (this.paExchEltColl1.getAbstractType() == this.laCollection1 ? 1 : 0) != 0);
    }
}

