/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class ScenarioTransition
extends TopDownTransitionTestCase {
    private CapabilityRealization laMyCapabilityRealization;
    private Scenario laFSMyCapabilityRealization;
    private Scenario laESMyCapabilityRealization;
    private Scenario laFSMyCapabilityRealizationES;
    private Scenario laESMyCapabilityRealizationIS;
    private Scenario laESMyCapabilityRealizationES;
    private InstanceRole laFS_LF_5;
    private InstanceRole laFS_LF_4;
    private InstanceRole laES_LogicalActor1;
    private InstanceRole laES_LA1;
    private InstanceRole laESMyCapabilityRealizationES_LogicalActor1;
    private InstanceRole laESMyCapabilityRealizationES_LA1;
    private SequenceMessage laFS_LF4LF5Exchange;
    private SequenceMessage laFS_LF4LF5ExchangeReturn;
    private SequenceMessage laES_LF12LF1Exchange;
    private SequenceMessage laES_LF12LF1ExchangeReturn;
    private SequenceMessage laESMyCapabilityRealizationES_LF12LF1Exchange;
    private SequenceMessage laESMyCapabilityRealizationES_LF12LF1ExchangeReturn;
    private CapabilityRealizationPkg paCapabilitiesPkg;
    private CapabilityRealization paMyCapabilityRealization;
    private Scenario paFSMyCapabilityRealization;
    private Scenario paESMyCapabilityRealization;
    private InstanceRole paFS_LF_5;
    private InstanceRole paFS_LF_4;
    private InstanceRole paES_LogicalActor1;
    private InstanceRole paES_LA1;
    private SequenceMessage paFS_LF4LF5Exchange;
    private SequenceMessage paFS_LF4LF5ExchangeReturn;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laMyCapabilityRealization = (CapabilityRealization)this.getObject(ModelLaPa.MyCapabilityRealizationId);
        this.laFSMyCapabilityRealization = (Scenario)this.getObject(ModelLaPa.FSMyCapabilityRealizationId);
        this.laFS_LF_5 = (InstanceRole)this.getObject(ModelLaPa.LF_5Id);
        this.laFS_LF_4 = (InstanceRole)this.getObject(ModelLaPa.LF_4Id);
        this.laFS_LF4LF5Exchange = (SequenceMessage)this.getObject(ModelLaPa.LF4LF5ExchangeId);
        this.laFS_LF4LF5ExchangeReturn = (SequenceMessage)this.getObject(ModelLaPa.LF4LF5ExchangeReturnId);
        this.laESMyCapabilityRealization = (Scenario)this.getObject(ModelLaPa.ESMyCapabilityRealizationId);
        this.laES_LogicalActor1 = (InstanceRole)this.getObject(ModelLaPa.LogicalActor1Id);
        this.laES_LA1 = (InstanceRole)this.getObject(ModelLaPa.LA1Id);
        this.laES_LF12LF1Exchange = (SequenceMessage)this.getObject(ModelLaPa.LF12LF1ExchangeId);
        this.laES_LF12LF1ExchangeReturn = (SequenceMessage)this.getObject(ModelLaPa.LF12LF1ExchangeReturnId);
        this.paCapabilitiesPkg = (CapabilityRealizationPkg)this.getObject(ModelLaPa.paCapabilitiesPkgId);
    }

    public void performTest() throws Exception {
        this.initSession();
        this.LAFStoPAFSInitializationTest();
        this.LAEStoPAESInitializationTest();
        this.FStoESInitializationTest();
        this.EStoISInitializationTest();
        this.ESFtoESBInitializationTest();
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    private void LAFStoPAFSInitializationTest() {
        this.performFStoFSTransition(Arrays.asList(this.laFSMyCapabilityRealization));
        this.paMyCapabilityRealization = (CapabilityRealization)this.paCapabilitiesPkg.getOwnedCapabilityRealizations().get(0);
        this.paFSMyCapabilityRealization = (Scenario)this.paMyCapabilityRealization.getOwnedScenarios().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paFSMyCapabilityRealization);
        String name = this.paFSMyCapabilityRealization.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this.laFSMyCapabilityRealization.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFSMyCapabilityRealization) == this.laFSMyCapabilityRealization ? 1 : 0) != 0);
        ScenarioKind actualKind = this.laFSMyCapabilityRealization.getKind();
        ScenarioKind expectedKind = ScenarioKind.FUNCTIONAL;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this.paFSMyCapabilityRealization.getOwnedInstanceRoles().size();
        int expectedIRNumber = this.laFSMyCapabilityRealization.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        int actualIFNumber = this.paFSMyCapabilityRealization.getOwnedInteractionFragments().size();
        int expectedIFNumber = this.laFSMyCapabilityRealization.getOwnedInteractionFragments().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIFNumber, expectedIFNumber), (actualIFNumber == expectedIFNumber ? 1 : 0) != 0);
        int actualMsgNumber = this.paFSMyCapabilityRealization.getOwnedMessages().size();
        int expectedMsgNumber = this.laFSMyCapabilityRealization.getOwnedMessages().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualMsgNumber, expectedMsgNumber), (actualMsgNumber == expectedMsgNumber ? 1 : 0) != 0);
        this.paFS_LF_5 = (InstanceRole)this.paFSMyCapabilityRealization.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paFS_LF_5);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFS_LF_5.getName(), (Object)this.laFS_LF_5.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFS_LF_5) == this.laFS_LF_5 ? 1 : 0) != 0);
        this.paFS_LF_4 = (InstanceRole)this.paFSMyCapabilityRealization.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paFS_LF_4);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFS_LF_4.getName(), (Object)this.laFS_LF_4.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFS_LF_4) == this.laFS_LF_4 ? 1 : 0) != 0);
        this.paFS_LF4LF5Exchange = (SequenceMessage)this.paFSMyCapabilityRealization.getOwnedMessages().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paFS_LF4LF5Exchange);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFS_LF4LF5Exchange.getName(), (Object)this.laFS_LF4LF5Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFS_LF4LF5Exchange) == this.laFS_LF4LF5Exchange ? 1 : 0) != 0);
        this.paFS_LF4LF5ExchangeReturn = (SequenceMessage)this.paFSMyCapabilityRealization.getOwnedMessages().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paFS_LF4LF5ExchangeReturn);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paFS_LF4LF5ExchangeReturn.getName(), (Object)this.laFS_LF4LF5ExchangeReturn.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paFS_LF4LF5ExchangeReturn) == this.laFS_LF4LF5ExchangeReturn ? 1 : 0) != 0);
    }

    private void LAEStoPAESInitializationTest() {
        this.performEStoESTransition(Arrays.asList(this.laESMyCapabilityRealization));
        this.paESMyCapabilityRealization = (Scenario)this.paMyCapabilityRealization.getOwnedScenarios().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paESMyCapabilityRealization);
        String name = this.paESMyCapabilityRealization.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this.laESMyCapabilityRealization.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paESMyCapabilityRealization) == this.laESMyCapabilityRealization ? 1 : 0) != 0);
        ScenarioKind actualKind = this.laESMyCapabilityRealization.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this.paESMyCapabilityRealization.getOwnedInstanceRoles().size();
        int expectedIRNumber = this.laESMyCapabilityRealization.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        this.paES_LogicalActor1 = (InstanceRole)this.paESMyCapabilityRealization.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paES_LogicalActor1);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paES_LogicalActor1.getName(), (Object)this.laES_LogicalActor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paES_LogicalActor1) == this.laES_LogicalActor1 ? 1 : 0) != 0);
        this.paES_LA1 = (InstanceRole)this.paESMyCapabilityRealization.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.paES_LA1);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paES_LA1.getName(), (Object)this.laES_LA1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paES_LA1) == this.laES_LA1 ? 1 : 0) != 0);
    }

    private void FStoESInitializationTest() {
        this.performFStoESTransition(Arrays.asList(this.laFSMyCapabilityRealization));
        this.laFSMyCapabilityRealizationES = (Scenario)this.laMyCapabilityRealization.getOwnedScenarios().get(2);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laFSMyCapabilityRealizationES);
        String name = this.laFSMyCapabilityRealizationES.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this.laFSMyCapabilityRealization.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laFSMyCapabilityRealizationES) == this.laFSMyCapabilityRealization ? 1 : 0) != 0);
        ScenarioKind actualKind = this.laFSMyCapabilityRealizationES.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
    }

    private void EStoISInitializationTest() {
        this.performEStoISTransition(Arrays.asList(this.laESMyCapabilityRealization));
        this.laESMyCapabilityRealizationIS = (Scenario)this.laMyCapabilityRealization.getOwnedScenarios().get(3);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationIS);
        String name = this.laESMyCapabilityRealizationIS.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this.laESMyCapabilityRealization.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationIS) == this.laESMyCapabilityRealization ? 1 : 0) != 0);
        ScenarioKind actualKind = this.laESMyCapabilityRealizationIS.getKind();
        ScenarioKind expectedKind = ScenarioKind.INTERFACE;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
    }

    private void ESFtoESBInitializationTest() {
        this.performESFtoESBTransition(Arrays.asList(this.laESMyCapabilityRealization));
        this.laESMyCapabilityRealizationES = (Scenario)this.laMyCapabilityRealization.getOwnedScenarios().get(4);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationES);
        String name = this.laESMyCapabilityRealizationES.getName();
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)name, (Object)this.laESMyCapabilityRealization.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationES) == this.laESMyCapabilityRealization ? 1 : 0) != 0);
        ScenarioKind actualKind = this.laESMyCapabilityRealizationES.getKind();
        ScenarioKind expectedKind = ScenarioKind.DATA_FLOW;
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualKind.getName(), expectedKind.getName()), (boolean)actualKind.equals((Object)expectedKind));
        int actualIRNumber = this.laESMyCapabilityRealizationES.getOwnedInstanceRoles().size();
        int expectedIRNumber = this.laESMyCapabilityRealization.getOwnedInstanceRoles().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIRNumber, expectedIRNumber), (actualIRNumber == expectedIRNumber ? 1 : 0) != 0);
        int actualIFNumber = this.laESMyCapabilityRealizationES.getOwnedInteractionFragments().size();
        int expectedIFNumber = this.laESMyCapabilityRealization.getOwnedInteractionFragments().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualIFNumber, expectedIFNumber), (actualIFNumber == expectedIFNumber ? 1 : 0) != 0);
        int actualMsgNumber = this.laESMyCapabilityRealizationES.getOwnedMessages().size();
        int expectedMsgNumber = this.laESMyCapabilityRealization.getOwnedMessages().size();
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, name, actualMsgNumber, expectedMsgNumber), (actualMsgNumber == expectedMsgNumber ? 1 : 0) != 0);
        this.laESMyCapabilityRealizationES_LogicalActor1 = (InstanceRole)this.laESMyCapabilityRealizationES.getOwnedInstanceRoles().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationES_LogicalActor1);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.laESMyCapabilityRealizationES_LogicalActor1.getName(), (Object)this.laES_LogicalActor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationES_LogicalActor1) == this.laES_LogicalActor1 ? 1 : 0) != 0);
        this.laESMyCapabilityRealizationES_LA1 = (InstanceRole)this.laESMyCapabilityRealizationES.getOwnedInstanceRoles().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationES_LA1);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.laESMyCapabilityRealizationES_LA1.getName(), (Object)this.laES_LA1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationES_LA1) == this.laES_LA1 ? 1 : 0) != 0);
        this.laESMyCapabilityRealizationES_LF12LF1Exchange = (SequenceMessage)this.laESMyCapabilityRealizationES.getOwnedMessages().get(0);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationES_LF12LF1Exchange);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.laESMyCapabilityRealizationES_LF12LF1Exchange.getName(), (Object)this.laES_LF12LF1Exchange.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationES_LF12LF1Exchange) == this.laES_LF12LF1Exchange ? 1 : 0) != 0);
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, this.laESMyCapabilityRealizationES_LF12LF1Exchange.getName()), (boolean)(this.laESMyCapabilityRealizationES_LF12LF1Exchange.getInvokedOperation() instanceof ComponentExchange));
        this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn = (SequenceMessage)this.laESMyCapabilityRealizationES.getOwnedMessages().get(1);
        ScenarioTransition.assertNotNull((String)Messages.NullError, (Object)this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn);
        ScenarioTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn.getName(), (Object)this.laES_LF12LF1ExchangeReturn.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn) == this.laES_LF12LF1ExchangeReturn ? 1 : 0) != 0);
        ScenarioTransition.assertTrue((String)MessageFormat.format(Messages.ErrorMessage, this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn.getName()), (boolean)(this.laESMyCapabilityRealizationES_LF12LF1ExchangeReturn.getInvokedOperation() instanceof ComponentExchange));
    }
}

