/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class ActorTransition
extends TopDownTransitionTestCase {
    private EntityPkg _rootOEPkg;
    private SystemComponentPkg _rootActorPkg;
    private Entity _rootOE;
    private Entity _entity1;
    private Entity _entity2;
    private Entity _entity3;
    private EntityPkg _subEntityPkg;
    private Entity _subEntity1;
    private Entity _actor1;
    private Entity _actor2;
    private Entity _subOpActor1;
    private SystemComponent _rootOEActor;
    private SystemComponent _entity1Actor;
    private SystemComponent _entity2Actor;
    private SystemComponent _entity3Actor;
    private SystemComponent _ctxActor1;
    private SystemComponent _ctxActor2;
    private SystemComponentPkg _subActorPkg;
    private SystemComponent _subEntity1Actor;
    private SystemComponent _ctxSubOpActor1;
    List<SystemComponent> _actors;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._rootOEPkg = (EntityPkg)this.getObject(ModelOaSa.rootOEPkgId);
        this._rootOE = (Entity)this.getObject(ModelOaSa.rootOEId);
        this._entity1 = (Entity)this.getObject(ModelOaSa.entity1Id);
        this._entity2 = (Entity)this.getObject(ModelOaSa.entity2Id);
        this._entity3 = (Entity)this.getObject(ModelOaSa.entity3Id);
        this._actor1 = (Entity)this.getObject(ModelOaSa.actor1Id);
        this._actor2 = (Entity)this.getObject(ModelOaSa.actor2Id);
        this._subEntityPkg = (EntityPkg)this.getObject(ModelOaSa.subEntityPkgId);
        this._subEntity1 = (Entity)this.getObject(ModelOaSa.subEntity1Id);
        this._rootActorPkg = (SystemComponentPkg)this.getObject(ModelOaSa.rootActorPkgId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performOE2ActorTransition(Collections.singletonList(this._entity1));
        this._entity1Actor = ProjectionTestUtils.getRecentlyCreatedActor(this._rootActorPkg);
        ActorTransition.assertNotNull((String)Messages.ErrorMessage, (Object)this._entity1Actor);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity1Actor.getName(), (Object)this._entity1.getName()), (ProjectionTestUtils.getRealizedEntity(this._entity1Actor) == this._entity1 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._rootActorPkg.getName(), (Object)2), (this._rootActorPkg.getOwnedSystemComponents().size() == 2 ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performOE2ActorTransition(Collections.singletonList(this._subEntity1));
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._rootActorPkg.getName(), (Object)2), (this._rootActorPkg.getOwnedSystemComponents().size() == 2 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)1), (this._rootActorPkg.getOwnedSystemComponentPkgs().size() == 1 ? 1 : 0) != 0);
        this._subActorPkg = (SystemComponentPkg)this._rootActorPkg.getOwnedSystemComponentPkgs().get(0);
        ActorTransition.assertNotNull((Object)this._subActorPkg);
        TraceableElement outgoing = ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._subActorPkg);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.ErrorMessage, (Object)this._subActorPkg.getName(), (Object)this._subEntityPkg.getName()), (outgoing == this._subEntityPkg ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongSize, (Object)this._subActorPkg.getName(), (Object)1), (this._subActorPkg.getOwnedSystemComponents().size() == 1 ? 1 : 0) != 0);
        this._subEntity1Actor = ProjectionTestUtils.getRecentlyCreatedActor(this._subActorPkg);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._subEntity1Actor.getName(), (Object)this._subEntity1.getName()), (ProjectionTestUtils.getRealizedEntity(this._subEntity1Actor) == this._subEntity1 ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performOE2ActorTransition(Collections.singletonList(this._rootOEPkg));
        this._rootOEActor = ProjectionTestUtils.getCreatedActor(this._rootOE);
        this._entity1Actor = ProjectionTestUtils.getCreatedActor(this._entity1);
        this._entity2Actor = ProjectionTestUtils.getCreatedActor(this._entity2);
        this._entity3Actor = ProjectionTestUtils.getCreatedActor(this._entity3);
        this._ctxActor1 = ProjectionTestUtils.getCreatedActor(this._actor1);
        this._ctxActor2 = ProjectionTestUtils.getCreatedActor(this._actor2);
        this._actors = Arrays.asList(this._rootOEActor, this._entity1Actor, this._entity2Actor, this._entity3Actor, this._ctxActor1, this._ctxActor2);
        for (SystemComponent actor : this._actors) {
            ActorTransition.assertNotNull((String)Messages.ErrorMessage, (Object)actor);
        }
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._rootOEActor.getName(), (Object)this._rootOE.getName()), (ProjectionTestUtils.getRealizedEntity(this._rootOEActor) == this._rootOE ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity1Actor.getName(), (Object)this._entity1.getName()), (ProjectionTestUtils.getRealizedEntity(this._entity1Actor) == this._entity1 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity2Actor.getName(), (Object)this._entity2.getName()), (ProjectionTestUtils.getRealizedEntity(this._entity2Actor) == this._entity2 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._entity3Actor.getName(), (Object)this._entity3.getName()), (ProjectionTestUtils.getRealizedEntity(this._entity3Actor) == this._entity3 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._ctxActor1.getName(), (Object)this._actor1.getName()), (ProjectionTestUtils.getRealizedEntity(this._ctxActor1) == this._actor1 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._ctxActor2.getName(), (Object)this._actor2.getName()), (ProjectionTestUtils.getRealizedEntity(this._ctxActor2) == this._actor2 ? 1 : 0) != 0);
        EList operationalEntities = this._rootOEPkg.getOwnedEntities();
        EList actors = this._rootActorPkg.getOwnedSystemComponents();
        ActorTransition.assertTrue((String)Messages.ErrorMessage, (operationalEntities.size() == actors.size() - 1 ? 1 : 0) != 0);
        ActorTransition.assertTrue((String)Messages.ErrorMessage, (this._subEntityPkg.getOwnedEntities().size() == this._subActorPkg.getOwnedSystemComponents().size() ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.performOE2ActorTransition(Collections.singletonList(this._rootOEPkg));
        List<SystemComponent> previousResult = this._actors;
        ArrayList projectedActors = new ArrayList(this._rootActorPkg.getOwnedSystemComponents());
        projectedActors.remove(BlockArchitectureExt.getRootBlockArchitecture((EObject)this._rootActorPkg).getSystem());
        ActorTransition.assertTrue((boolean)previousResult.containsAll(projectedActors));
        ActorTransition.assertTrue((previousResult.size() == projectedActors.size() ? 1 : 0) != 0);
        ActorTransition.assertTrue((this._subEntityPkg.getOwnedEntities().size() == this._subActorPkg.getOwnedSystemComponents().size() ? 1 : 0) != 0);
    }

    public void performTest5() throws Exception {
        this.getExecutionManager((EObject)this._rootOEPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                ActorTransition.this._subOpActor1 = OaFactory.eINSTANCE.createEntity("SupOpActor1");
                ActorTransition.this._subOpActor1.setActor(true);
                ActorTransition.this._subEntityPkg.getOwnedEntities().add((Object)ActorTransition.this._subOpActor1);
                Part subOpActor1Part = CsFactory.eINSTANCE.createPart(ActorTransition.this._subOpActor1.getName());
                subOpActor1Part.setAbstractType((AbstractType)ActorTransition.this._subOpActor1);
                ActorTransition.this._subEntity1.getOwnedFeatures().add((Object)subOpActor1Part);
                ActorTransition.this._actor1.destroy();
                ActorTransition.this._entity2.destroy();
                ActorTransition.this._actor2.setName("OpActor2");
            }
        });
        this.performOE2ActorTransition(Collections.singletonList(this._rootOEPkg));
        this._ctxSubOpActor1 = ProjectionTestUtils.getRecentlyCreatedActor(this._subActorPkg);
        ActorTransition.assertNotNull((String)Messages.ErrorMessage, (Object)this._ctxSubOpActor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.WrongRealization, (Object)this._ctxSubOpActor1.getName(), (Object)this._subOpActor1.getName()), (ProjectionTestUtils.getRealizedEntity(this._ctxSubOpActor1) == this._subOpActor1 ? 1 : 0) != 0);
        ActorTransition.assertNotNull((String)Messages.ErrorMessage, (Object)this._ctxActor1);
        ActorTransition.assertNotNull((String)Messages.ErrorMessage, (Object)this._entity2Actor);
        ActorTransition.assertNull((String)NLS.bind((String)Messages.ErrorMessage, (Object)this._ctxActor1.getName()), (Object)ProjectionTestUtils.getRealizedEntity(this._ctxActor1));
        ActorTransition.assertNull((String)NLS.bind((String)Messages.ErrorMessage, (Object)this._entity2Actor.getName()), (Object)ProjectionTestUtils.getRealizedEntity(this._entity2Actor));
        ActorTransition.assertFalse((String)NLS.bind((String)Messages.ErrorMessage, (Object)this._ctxActor2.getName(), (Object)"OpActor2"), (boolean)this._ctxActor2.getName().equals("OpActor2"));
    }
}

