/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.oa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.test.transition.ju.CodeHelper;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelOaSa;

public class DataTransition
extends TopDownTransitionTestCase {
    private DataPkg _oaDataPkg;
    private DataPkg _oaMyDataPkg;
    private Class _oaPrimitiveClass;
    private Class _oaSuperClass;
    private Class _oaSubClass;
    private Class _oaUnion;
    private Collection _oaMyCollection;
    private Service _oaMyService;
    private Parameter _oaMyParameter;
    private BooleanType _oaMyBooleanType;
    private LiteralBooleanValue _oaFalseValue;
    private LiteralBooleanValue _oaTrueValue;
    private StringType _oaSuperST;
    private StringType _oaSubST;
    private Property _oaProperty1;
    private Service _oaService1;
    private Parameter _oaParameter1;
    private Service _oaService2;
    private Parameter _oaParameter2;
    private Constraint _oaConstraint1;
    private DataPkg _saDataPkg;
    private DataPkg _saMyDataPkg;
    private Class _saPrimitiveClass;
    private Class _saSuperClass;
    private Class _saSubClass;
    private Class _saUnion;
    private Collection _saMyCollection;
    private Service _saMyService;
    private Parameter _saMyParameter;
    private BooleanType _saMyBooleanType;
    private LiteralBooleanValue _saFalseValue;
    private LiteralBooleanValue _saTrueValue;
    private StringType _saSuperST;
    private StringType _saSubST;
    private Property _saProperty1;
    private Service _saService1;
    private Parameter _saParameter1;
    private Service _saService2;
    private Parameter _saParameter2;
    private Constraint _saConstraint1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this._oaDataPkg = (DataPkg)this.getObject(ModelOaSa.oaDataPkgId);
        this._oaPrimitiveClass = (Class)this.getObject(ModelOaSa.primitiveClassId);
        this._oaSuperClass = (Class)this.getObject(ModelOaSa.superClassId);
        this._oaSubClass = (Class)this.getObject(ModelOaSa.subClassId);
        this._oaSuperST = (StringType)this.getObject(ModelOaSa.superSTId);
        this._oaSubST = (StringType)this.getObject(ModelOaSa.subSTId);
        this._oaProperty1 = (Property)this.getObject(ModelOaSa.property1Id);
        this._oaService1 = (Service)this.getObject(ModelOaSa.service1Id);
        this._oaParameter1 = (Parameter)this.getObject(ModelOaSa.parameter1Id);
        this._oaService2 = (Service)this.getObject(ModelOaSa.service2Id);
        this._oaConstraint1 = (Constraint)this.getObject(ModelOaSa.constraint1Id);
        this._saDataPkg = (DataPkg)this.getObject(ModelOaSa.saDataPkgId);
        this._oaMyDataPkg = (DataPkg)this.getObject(ModelOaSa.oaMyDataPkgId);
        this._oaMyCollection = (Collection)this.getObject(ModelOaSa.oaMyCollectionId);
        this._oaMyService = (Service)this.getObject(ModelOaSa.oaMyServiceId);
        this._oaMyParameter = (Parameter)this.getObject(ModelOaSa.oaMyParameterId);
        this._oaMyBooleanType = (BooleanType)this.getObject(ModelOaSa.oaMyBooleanTypeId);
        this._oaFalseValue = (LiteralBooleanValue)this.getObject(ModelOaSa.oaFalseValueId);
        this._oaTrueValue = (LiteralBooleanValue)this.getObject(ModelOaSa.oaTrueValueId);
        this.performTest1();
        this.performTest2();
        this.performTest3();
        this.performTest4();
        this.performTest5();
    }

    public void performTest1() throws Exception {
        this.performDataTransition(Collections.singletonList(this._oaMyCollection));
        this._saMyDataPkg = (DataPkg)this._saDataPkg.getOwnedDataPkgs().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saMyDataPkg);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saMyDataPkg.getName(), (Object)this._oaMyDataPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saMyDataPkg) == this._oaMyDataPkg ? 1 : 0) != 0);
        this._saMyBooleanType = (BooleanType)this._saMyDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saMyBooleanType);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saMyBooleanType.getName(), (Object)this._oaMyBooleanType.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saMyBooleanType) == this._oaMyBooleanType ? 1 : 0) != 0);
        this._saFalseValue = (LiteralBooleanValue)this._saMyBooleanType.getOwnedLiterals().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saFalseValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saFalseValue.getName(), (Object)this._oaFalseValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saFalseValue) == this._oaFalseValue ? 1 : 0) != 0);
        DataTransition.assertFalse((String)NLS.bind((String)Messages.WrongValue, (Object)this._saFalseValue.getName()), (boolean)this._saFalseValue.isValue());
        this._saTrueValue = (LiteralBooleanValue)this._saMyBooleanType.getOwnedLiterals().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saTrueValue);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saTrueValue.getName(), (Object)this._oaTrueValue.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saTrueValue) == this._oaTrueValue ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongValue, (Object)this._saTrueValue.getName()), (boolean)this._saTrueValue.isValue());
        this._saMyCollection = (Collection)this._saDataPkg.getOwnedCollections().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saMyCollection);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saMyCollection.getName(), (Object)this._oaMyCollection.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saMyCollection) == this._oaMyCollection ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._saMyCollection.getName(), (Object)this._saMyBooleanType.getName()), (this._saMyCollection.getType() == this._saMyBooleanType ? 1 : 0) != 0);
        this._saMyService = (Service)this._saMyCollection.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saMyService);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saMyService.getName(), (Object)this._oaMyService.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saMyService) == this._oaMyService ? 1 : 0) != 0);
        this._saMyParameter = (Parameter)this._saMyService.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saMyParameter);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saMyParameter.getName(), (Object)this._oaMyParameter.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saMyParameter) == this._oaMyParameter ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._saMyParameter.getName(), (Object)this._saMyBooleanType.getName()), (this._saMyParameter.getType() == this._saMyBooleanType ? 1 : 0) != 0);
    }

    public void performTest2() throws Exception {
        this.performDataTransition(Collections.singletonList(this._oaPrimitiveClass));
        this._saPrimitiveClass = ProjectionTestUtils.getRecentlyAddedClass(this._saDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saPrimitiveClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saPrimitiveClass.getName(), (Object)this._oaPrimitiveClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saPrimitiveClass) == this._oaPrimitiveClass ? 1 : 0) != 0);
    }

    public void performTest3() throws Exception {
        this.performDataTransition(Collections.singletonList(this._oaSubClass));
        this._saSuperST = (StringType)this._saDataPkg.getOwnedDataTypes().get(0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saSuperST.getName(), (Object)this._oaSuperST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saSuperST) == this._oaSuperST ? 1 : 0) != 0);
        this._saSubST = (StringType)this._saDataPkg.getOwnedDataTypes().get(1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saSubST.getName(), (Object)this._oaSubST.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saSubST) == this._oaSubST ? 1 : 0) != 0);
        this._saSubClass = (Class)CodeHelper.getChildTracingElement((EObject)this._saDataPkg, (EObject)this._oaSubClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saSubClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saSubClass.getName(), (Object)this._oaSubClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saSubClass) == this._oaSubClass ? 1 : 0) != 0);
        this._saService1 = (Service)this._saSubClass.getContainedOperations().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saService1.getName(), (Object)this._oaService1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saService1) == this._oaService1 ? 1 : 0) != 0);
        this._saParameter1 = (Parameter)this._saService1.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saParameter1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saParameter1.getName(), (Object)this._oaParameter1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saParameter1) == this._oaParameter1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._saParameter1.getName(), (Object)this._saSuperST.getName()), (this._saParameter1.getType() == this._saSuperST ? 1 : 0) != 0);
        this._saService2 = (Service)this._saSubClass.getContainedOperations().get(1);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saService2);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saService2.getName(), (Object)this._oaService2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saService2) == this._oaService2 ? 1 : 0) != 0);
        this._saSuperClass = (Class)CodeHelper.getChildTracingElement((EObject)this._saDataPkg, (EObject)this._oaSuperClass);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saSuperClass.getName(), (Object)this._oaSuperClass.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saSuperClass) == this._oaSuperClass ? 1 : 0) != 0);
        this._saProperty1 = (Property)this._saSuperClass.getContainedProperties().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saSuperClass);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saProperty1.getName(), (Object)this._oaProperty1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saProperty1) == this._oaProperty1 ? 1 : 0) != 0);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.WrongType, (Object)this._saProperty1.getName(), (Object)this._saSubST.getName()), (this._saProperty1.getType() == this._saSubST ? 1 : 0) != 0);
        this._saConstraint1 = (Constraint)this._saSubClass.getOwnedConstraints().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saConstraint1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saConstraint1.getName(), (Object)this._oaConstraint1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saConstraint1) == this._oaConstraint1 ? 1 : 0) != 0);
    }

    public void performTest4() throws Exception {
        this.performDataTransition(Collections.singletonList(this._oaDataPkg));
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this._oaDataPkg.getOwnedClasses().size(), (int)this._saDataPkg.getOwnedClasses().size());
        DataTransition.assertEquals((String)Messages.ProjectionSizeError, (int)this._oaDataPkg.getOwnedDataTypes().size(), (int)this._saDataPkg.getOwnedDataTypes().size());
    }

    public void performTest5() throws Exception {
        this.getExecutionManager((EObject)this._oaDataPkg).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DataTransition.this._oaService1.destroy();
                DataTransition.this._oaUnion = InformationFactory.eINSTANCE.createUnion("Union1");
                DataTransition.this._oaDataPkg.getOwnedClasses().add((Object)DataTransition.this._oaUnion);
                DataTransition.this._oaParameter2 = InformationFactory.eINSTANCE.createParameter("Parameter2");
                DataTransition.this._oaParameter2.setAbstractType((AbstractType)DataTransition.this._oaUnion);
                DataTransition.this._oaService2.getOwnedParameters().add((Object)DataTransition.this._oaParameter2);
            }
        });
        this.performDataTransition(Collections.singletonList(this._oaSubClass));
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saService1);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saService1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saService1) == null ? 1 : 0) != 0);
        this._saParameter2 = (Parameter)this._saService2.getOwnedParameters().get(0);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saParameter2);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saParameter2.getName(), (Object)this._oaParameter2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saParameter2) == this._oaParameter2 ? 1 : 0) != 0);
        this._saUnion = ProjectionTestUtils.getRecentlyAddedClass(this._saDataPkg);
        DataTransition.assertNotNull((String)Messages.NullError, (Object)this._saUnion);
        DataTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this._saUnion.getName(), (Object)this._oaUnion.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this._saUnion) == this._oaUnion ? 1 : 0) != 0);
    }
}

